/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.NetStat;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Swap;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.system.CpuInformation;
import org.rhq.core.system.FileSystemInfo;
import org.rhq.core.system.NetworkAdapterInfo;
import org.rhq.core.system.NetworkAdapterStats;
import org.rhq.core.system.NetworkStats;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.ServiceInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoException;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.system.pquery.ProcessInfoQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeSystemInfo
implements SystemInfo {
    private final Log log = LogFactory.getLog(NativeSystemInfo.class);

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public OperatingSystemType getOperatingSystemType() {
        OperatingSystem os = OperatingSystem.getInstance();
        if ("Linux".equals(os.getName())) {
            return OperatingSystemType.LINUX;
        }
        if ("Solaris".equals(os.getName())) {
            return OperatingSystemType.SOLARIS;
        }
        if ("Win32".equals(os.getName())) {
            return OperatingSystemType.WINDOWS;
        }
        if ("HPUX".equals(os.getName())) {
            return OperatingSystemType.HPUX;
        }
        if ("AIX".equals(os.getName())) {
            return OperatingSystemType.AIX;
        }
        if ("MacOSX".equals(os.getName())) {
            return OperatingSystemType.OSX;
        }
        if ("FreeBSD".equals(os.getName())) {
            return OperatingSystemType.BSD;
        }
        return OperatingSystemType.JAVA;
    }

    @Override
    public String getOperatingSystemName() {
        return OperatingSystem.getInstance().getName();
    }

    @Override
    public String getOperatingSystemVersion() {
        return OperatingSystem.getInstance().getVersion();
    }

    @Override
    public String getHostname() throws SystemInfoException {
        Sigar sigar = new Sigar();
        try {
            String string = sigar.getNetInfo().getHostName();
            return string;
        }
        catch (Exception e) {
            try {
                String string = InetAddress.getLocalHost().getCanonicalHostName();
                return string;
            }
            catch (UnknownHostException uhe) {
                throw new SystemInfoException(e);
            }
        }
        finally {
            sigar.close();
        }
    }

    @Override
    public List<NetworkAdapterInfo> getAllNetworkAdapters() throws SystemInfoException {
        ArrayList<NetworkAdapterInfo> adapters = new ArrayList<NetworkAdapterInfo>();
        Sigar sigar = new Sigar();
        try {
            String[] interfaceNames = sigar.getNetInterfaceList();
            if (interfaceNames != null) {
                for (String interfaceName : interfaceNames) {
                    if (interfaceName.indexOf(58) != -1) continue;
                    adapters.add(new NetworkAdapterInfo(sigar.getNetInterfaceConfig(interfaceName)));
                }
            }
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
        finally {
            sigar.close();
        }
        return adapters;
    }

    @Override
    public NetworkAdapterStats getNetworkAdapterStats(String interfaceName) {
        Sigar sigar = new Sigar();
        try {
            NetInterfaceStat interfaceStat = sigar.getNetInterfaceStat(interfaceName);
            NetworkAdapterStats networkAdapterStats = new NetworkAdapterStats(interfaceStat);
            return networkAdapterStats;
        }
        catch (SigarException e) {
            throw new SystemInfoException(e);
        }
        finally {
            sigar.close();
        }
    }

    @Override
    public NetworkStats getNetworkStats(String addressName, int port) {
        Sigar sigar = new Sigar();
        try {
            InetAddress address = InetAddress.getByName(addressName);
            NetStat interfaceStat = sigar.getNetStat(address.getAddress(), (long)port);
            NetworkStats networkStats = new NetworkStats(interfaceStat);
            return networkStats;
        }
        catch (SigarException e) {
            throw new SystemInfoException(e);
        }
        catch (UnknownHostException e) {
            throw new SystemInfoException(e);
        }
        finally {
            sigar.close();
        }
    }

    private List<InetAddress> getInetAddressInList(String address) throws UnknownHostException {
        ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
        if (address != null) {
            inetAddresses.add(InetAddress.getByName(address));
        }
        return inetAddresses;
    }

    @Override
    public List<ServiceInfo> getAllServices() throws SystemInfoException {
        throw new UnsupportedOperationException("Cannot get services for this plaform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProcessInfo> getAllProcesses() {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        long[] pids = null;
        Sigar sigar = new Sigar();
        try {
            pids = sigar.getProcList();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to get list of all processes", (Throwable)e);
        }
        finally {
            sigar.close();
        }
        if (pids != null) {
            for (long pid : pids) {
                ProcessInfo info = new ProcessInfo(pid);
                processes.add(info);
            }
        }
        return processes;
    }

    @Override
    public List<ProcessInfo> getProcesses(String piq) {
        ProcessInfoQuery piql = new ProcessInfoQuery(this.getAllProcesses());
        return piql.query(piq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessInfo getThisProcess() {
        long self;
        Sigar sigar = new Sigar();
        try {
            self = sigar.getPid();
        }
        finally {
            sigar.close();
        }
        ProcessInfo info = new ProcessInfo(self);
        return info;
    }

    @Override
    public ProcessExecutionResults executeProcess(ProcessExecution processExecution) {
        return SystemInfoFactory.createJavaSystemInfo().executeProcess(processExecution);
    }

    @Override
    public int getNumberOfCpus() {
        Sigar sigar = new Sigar();
        try {
            int n = sigar.getCpuPercList().length;
            return n;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Cannot get number of CPUs from native layer", e);
        }
        finally {
            sigar.close();
        }
    }

    @Override
    public Mem getMemoryInfo() {
        Sigar sigar = new Sigar();
        try {
            Mem mem = sigar.getMem();
            return mem;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Cannot get memory info from native layer", e);
        }
        finally {
            sigar.close();
        }
    }

    @Override
    @Nullable
    public Swap getSwapInfo() {
        Sigar sigar = new Sigar();
        try {
            int enabledCpuCount = sigar.getCpuPercList().length;
            int totalCpuCount = sigar.getCpuInfoList().length;
            if (enabledCpuCount < totalCpuCount) {
                this.log.info((Object)("Aborting swap info collection because one or more CPUs is disabled - " + enabledCpuCount + " out of " + totalCpuCount + " CPUs are enabled."));
                Swap swap = null;
                return swap;
            }
            Swap swap = sigar.getSwap();
            return swap;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Cannot get swap info from native layer", e);
        }
        finally {
            sigar.close();
        }
    }

    @Override
    public String readLineFromConsole(boolean noEcho) throws IOException {
        String input = noEcho ? Sigar.getPassword((String)"") : new BufferedReader(new InputStreamReader(System.in)).readLine();
        return input;
    }

    @Override
    public void writeLineToConsole(String line) throws IOException {
        System.out.print(line);
    }

    @Override
    public CpuInformation getCpu(int cpuIndex) {
        return new CpuInformation(cpuIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileSystemInfo> getFileSystems() {
        ArrayList mountPoints = new ArrayList();
        Sigar sigar = new Sigar();
        try {
            FileSystemMap map = sigar.getFileSystemMap();
            mountPoints.addAll(map.keySet());
        }
        catch (Exception e) {
            this.log.warn((Object)"Cannot obtain native file system information", (Throwable)e);
        }
        finally {
            sigar.close();
        }
        ArrayList<FileSystemInfo> infos = new ArrayList<FileSystemInfo>();
        for (String mountPoint : mountPoints) {
            infos.add(new FileSystemInfo(mountPoint));
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystemInfo getFileSystem(String path) {
        String mountPoint = null;
        Sigar sigar = new Sigar();
        try {
            FileSystem mountPointForPath = sigar.getFileSystemMap().getMountPoint(path);
            if (mountPointForPath != null) {
                mountPoint = mountPointForPath.getDirName();
            }
        }
        catch (Throwable e) {
            this.log.warn((Object)("Cannot obtain native file system information for [" + path + "]"), e);
        }
        finally {
            sigar.close();
        }
        FileSystemInfo fileSystem = new FileSystemInfo(mountPoint);
        return fileSystem;
    }

    @Override
    public String getSystemArchitecture() {
        OperatingSystem op = OperatingSystem.getInstance();
        return op.getArch();
    }

    NativeSystemInfo() {
    }
}

