/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcCred;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.ProcTime;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.system.AggregateProcessInfo;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoException;
import org.rhq.core.system.SystemInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInfo {
    private final Log log = LogFactory.getLog((String)ProcessInfo.class.getName());
    protected long pid;
    protected String name;
    protected String baseName;
    protected String[] commandLine;
    protected Map<String, String> environmentVariables;
    protected ProcState procState;
    protected ProcExe procExe;
    protected ProcTime procTime;
    protected ProcMem procMem;
    protected ProcCpu procCpu;
    protected ProcFd procFd;
    protected ProcCred procCred;
    protected ProcCredName procCredName;
    private boolean loggedPermissionsError = false;
    private static final String UNKNOWN = "?";

    protected ProcessInfo() {
    }

    public ProcessInfo(long pid) throws SystemInfoException {
        this.update(pid);
    }

    public void refresh() throws SystemInfoException {
        this.update(this.pid);
    }

    private void update(long pid) throws SystemInfoException {
        Sigar sigar = new Sigar();
        try {
            ProcState procState = null;
            try {
                procState = sigar.getProcState(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e);
            }
            ProcExe procExe = null;
            try {
                procExe = sigar.getProcExe(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e);
            }
            ProcTime procTime = null;
            try {
                procTime = sigar.getProcTime(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e);
            }
            if (this.pid == 0L) {
                String[] procArgs = null;
                try {
                    procArgs = sigar.getProcArgs(pid);
                }
                catch (Exception e) {
                    this.handleSigarCallException(e);
                }
                Map procEnv = null;
                try {
                    procEnv = sigar.getProcEnv(pid);
                }
                catch (Exception e) {
                    this.handleSigarCallException(e);
                }
                this.pid = pid;
                this.name = procExe != null ? procExe.getName() : UNKNOWN;
                this.baseName = this.determineBaseName(procExe, procState);
                this.commandLine = procArgs != null ? procArgs : new String[]{};
                this.environmentVariables = new HashMap<String, String>();
                if (procEnv == null) {
                    this.log.debug((Object)("SIGAR returned a null environment for [" + this.baseName + "] process with pid [" + this.pid + "]"));
                } else {
                    boolean isWindows;
                    SystemInfo systemInfo = SystemInfoFactory.createJavaSystemInfo();
                    boolean bl = isWindows = systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS;
                    if (isWindows) {
                        for (Map.Entry env : procEnv.entrySet()) {
                            this.environmentVariables.put(((String)env.getKey()).toUpperCase(), (String)env.getValue());
                        }
                    } else {
                        this.environmentVariables.putAll(procEnv);
                    }
                }
            }
            this.procState = procState;
            this.procExe = procExe;
            this.procTime = procTime;
            try {
                this.procMem = sigar.getProcMem(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e);
            }
            try {
                this.procCpu = sigar.getProcCpu(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e);
            }
            try {
                this.procFd = sigar.getProcFd(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e);
            }
            try {
                this.procCred = sigar.getProcCred(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e);
            }
            try {
                this.procCredName = sigar.getProcCredName(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e);
            }
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
        finally {
            sigar.close();
        }
    }

    private void handleSigarCallException(Exception e) {
        if (e instanceof SigarPermissionDeniedException) {
            if (!this.loggedPermissionsError) {
                String currentUserName = System.getProperty("user.name");
                this.log.debug((Object)("Unable to obtain all process info for process with pid [" + this.pid + "]. The process is most likely owned by a user other than the user that owns the RHQ plugin container's process (" + currentUserName + ")."));
                this.loggedPermissionsError = true;
            }
        } else if (e instanceof SigarNotImplementedException) {
            this.log.debug((Object)("Unable to obtain all process info for process with pid [" + this.pid + "]. Cause: " + e));
        } else {
            this.log.debug((Object)("Unexpected error occurred while looking up process info for process with pid [" + this.pid + "]. Did the process die? Cause: " + e));
        }
    }

    private String determineBaseName(ProcExe exe, ProcState state) {
        int slash;
        String base = null;
        if (exe != null && (base = exe.getName()) != null && (slash = Math.max(base.lastIndexOf(92), base.lastIndexOf(47))) > -1 && slash + 1 < base.length()) {
            base = base.substring(slash + 1);
        }
        if (base == null && state != null && state.getName() != null) {
            base = state.getName();
        }
        return base != null ? base : UNKNOWN;
    }

    public long getPid() {
        return this.pid;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String[] getCommandLine() {
        return this.commandLine;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Nullable
    public String getEnvironmentVariable(@NotNull String name) {
        boolean isWindows;
        SystemInfo systemInfo = SystemInfoFactory.createJavaSystemInfo();
        boolean bl = isWindows = systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS;
        if (this.environmentVariables == null) {
            return null;
        }
        return this.environmentVariables.get(isWindows ? name.toUpperCase() : name);
    }

    public long getParentPid() throws SystemInfoException {
        return this.procState != null ? this.procState.getPpid() : 0L;
    }

    public ProcState getState() throws SystemInfoException {
        return this.procState;
    }

    public ProcExe getExecutable() throws SystemInfoException {
        return this.procExe;
    }

    public ProcTime getTime() throws SystemInfoException {
        return this.procTime;
    }

    public ProcMem getMemory() throws SystemInfoException {
        return this.procMem;
    }

    public ProcCpu getCpu() throws SystemInfoException {
        return this.procCpu;
    }

    public ProcFd getFileDescriptor() throws SystemInfoException {
        return this.procFd;
    }

    public ProcCred getCredentials() throws SystemInfoException {
        return this.procCred;
    }

    public ProcCredName getCredentialsName() throws SystemInfoException {
        return this.procCredName;
    }

    public String getCurrentWorkingDirectory() throws SystemInfoException {
        return this.procExe.getCwd();
    }

    public boolean isRunning() throws SystemInfoException {
        boolean running = false;
        if (this.procState != null) {
            running = this.procState.getState() == 'R' || this.procState.getState() == 'S' || this.procState.getState() == 'D';
        }
        return running;
    }

    public AggregateProcessInfo getAggregateProcessTree() {
        AggregateProcessInfo root = new AggregateProcessInfo(this.pid);
        return root;
    }

    public int hashCode() {
        return Long.valueOf(this.pid).intValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ProcessInfo)) {
            return false;
        }
        return this.pid == ((ProcessInfo)obj).pid;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("process: ");
        s.append("pid=[");
        s.append(this.getPid());
        s.append("], name=[");
        s.append(!this.getName().equals(UNKNOWN) ? this.getName() : this.getBaseName());
        s.append("], ppid=[");
        try {
            s.append(this.getParentPid());
        }
        catch (Exception e) {
            s.append(e);
        }
        s.append("]");
        return s.toString();
    }
}

