/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.system.JavaSystemInfo;
import org.rhq.core.system.NativeSystemInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.WindowsNativeSystemInfo;
import org.rhq.core.util.exception.ThrowableUtil;

public class SystemInfoFactory {
    private static final Log LOG = LogFactory.getLog(SystemInfoFactory.class);
    private static final String NATIVE_LIBRARY_CLASS_NAME = "org.hyperic.sigar.Sigar";
    private static boolean nativeLibraryLoadable;
    private static boolean disabled;
    private static boolean initialized;
    private static Map<NativeApi, AccessibleObject> nativeApis;

    public static synchronized String getNativeSystemInfoVersion() {
        String version = null;
        Throwable error = null;
        SystemInfoFactory.initialize();
        if (SystemInfoFactory.isNativeSystemInfoAvailable() && !SystemInfoFactory.isNativeSystemInfoDisabled()) {
            try {
                version = "Version=" + SystemInfoFactory.invokeApi(NativeApi.VERSION_STRING, new Object[0]) + " (" + SystemInfoFactory.invokeApi(NativeApi.BUILD_DATE, new Object[0]) + "); Native version=" + SystemInfoFactory.invokeApi(NativeApi.NATIVE_VERSION_STRING, new Object[0]) + " (" + SystemInfoFactory.invokeApi(NativeApi.NATIVE_BUILD_DATE, new Object[0]) + ")";
            }
            catch (Throwable t) {
                error = t;
            }
        }
        if (version == null) {
            version = "Native system not supported - Java version is " + System.getProperty("java.version");
            if (error != null) {
                version = version + " : " + error;
            }
        }
        return version;
    }

    public static synchronized void disableNativeSystemInfo() {
        disabled = true;
    }

    public static synchronized void enableNativeSystemInfo() {
        disabled = false;
    }

    public static synchronized boolean isNativeSystemInfoDisabled() {
        return disabled;
    }

    public static boolean isNativeSystemInfoAvailable() {
        return nativeLibraryLoadable;
    }

    public static synchronized boolean isNativeSystemInfoInitialized() {
        return initialized;
    }

    public static synchronized SystemInfo createSystemInfo() {
        SystemInfoFactory.initialize();
        SystemInfo nativePlatform = null;
        if (SystemInfoFactory.isNativeSystemInfoAvailable() && !SystemInfoFactory.isNativeSystemInfoDisabled()) {
            nativePlatform = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 ? new WindowsNativeSystemInfo() : new NativeSystemInfo();
        }
        if (nativePlatform == null) {
            nativePlatform = new JavaSystemInfo();
        }
        return nativePlatform;
    }

    public static SystemInfo createJavaSystemInfo() {
        return new JavaSystemInfo();
    }

    public static synchronized void shutdown() {
        if (initialized) {
            initialized = false;
        }
    }

    private static synchronized void initialize() {
        if (!initialized && SystemInfoFactory.isNativeSystemInfoAvailable() && !SystemInfoFactory.isNativeSystemInfoDisabled()) {
            try {
                SystemInfoFactory.invokeApi(NativeApi.load, new Object[0]);
                initialized = true;
            }
            catch (Throwable t) {
                LOG.warn((Object)("Native library not available on this platform: " + ThrowableUtil.getAllMessages((Throwable)t)));
                LOG.debug((Object)"Native library failure stack trace follows: ", t);
                nativeLibraryLoadable = false;
                disabled = true;
            }
        }
    }

    private static final Object invokeApi(NativeApi api, Object ... args) throws Throwable {
        AccessibleObject accessibleObject = nativeApis.get((Object)api);
        if (accessibleObject instanceof Method) {
            return ((Method)accessibleObject).invoke(null, args);
        }
        return ((Field)accessibleObject).get(null);
    }

    private static String findNativeLibrariesRootDirectory() throws Exception {
        String rootDir = null;
        File jniLocation = null;
        URL jarLocation = null;
        if (SystemInfoFactory.isNativeSystemInfoAvailable() && (rootDir = System.getProperty("rhq.native-libraries-root-directory")) == null) {
            jarLocation = Class.forName(NATIVE_LIBRARY_CLASS_NAME).getProtectionDomain().getCodeSource().getLocation();
            if (jarLocation != null) {
                jniLocation = new File(jarLocation.toURI()).getParentFile();
            }
            if (jniLocation != null && jniLocation.exists()) {
                rootDir = jniLocation.getAbsolutePath();
            } else {
                throw new Exception("Native JNI libraries cannot be found: jar-location=[" + jarLocation + "], jni-location=[" + jniLocation + "]");
            }
        }
        LOG.debug((Object)("Root directory to the native library is: " + rootDir));
        return rootDir;
    }

    private SystemInfoFactory() {
    }

    static {
        initialized = false;
        nativeApis = new HashMap<NativeApi, AccessibleObject>();
        try {
            Class<?> clazz = Class.forName(NATIVE_LIBRARY_CLASS_NAME);
            nativeApis.put(NativeApi.load, clazz.getMethod(NativeApi.load.name(), new Class[0]));
            nativeApis.put(NativeApi.VERSION_STRING, clazz.getField(NativeApi.VERSION_STRING.name()));
            nativeApis.put(NativeApi.BUILD_DATE, clazz.getField(NativeApi.BUILD_DATE.name()));
            nativeApis.put(NativeApi.NATIVE_VERSION_STRING, clazz.getField(NativeApi.NATIVE_VERSION_STRING.name()));
            nativeApis.put(NativeApi.NATIVE_BUILD_DATE, clazz.getField(NativeApi.NATIVE_BUILD_DATE.name()));
            SystemInfoFactory.invokeApi(NativeApi.load, new Object[0]);
            nativeLibraryLoadable = true;
        }
        catch (Throwable t) {
            nativeLibraryLoadable = false;
            LOG.warn((Object)"System info API not accessible on this platform (native shared library not found in java.library.path).");
            LOG.trace((Object)"Stack trace...", t);
        }
        disabled = !nativeLibraryLoadable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NativeApi {
        load,
        VERSION_STRING,
        BUILD_DATE,
        NATIVE_VERSION_STRING,
        NATIVE_BUILD_DATE;

    }
}

