/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import org.rhq.enterprise.agent.ExternalizableStrategyCommandPreprocessor;
import org.rhq.enterprise.communications.util.prefs.PreferencesUpgrade;
import org.rhq.enterprise.communications.util.prefs.PreferencesUpgradeStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentConfigurationUpgrade
extends PreferencesUpgrade {
    public static void upgradeToLatest(Preferences preferences) {
        new AgentConfigurationUpgrade().upgrade(preferences, 5);
    }

    public AgentConfigurationUpgrade() {
        super(AgentConfigurationUpgrade.getSteps());
    }

    public String getConfigurationSchemaVersionPreference() {
        return "rhq.agent.configuration-schema-version";
    }

    private static List<PreferencesUpgradeStep> getSteps() {
        ArrayList<PreferencesUpgradeStep> list = new ArrayList<PreferencesUpgradeStep>();
        list.add(new Step1to2());
        list.add(new Step2to3());
        list.add(new Step3to4());
        list.add(new Step4to5());
        return list;
    }

    static class Step4to5
    extends PreferencesUpgradeStep {
        Step4to5() {
        }

        public int getSupportedConfigurationSchemaVersion() {
            return 5;
        }

        public void upgrade(Preferences preferences) {
            String newPreprocessor = ExternalizableStrategyCommandPreprocessor.class.getName();
            String val = preferences.get("rhq.agent.client.command-preprocessors", null);
            if (val != null && !val.contains(newPreprocessor)) {
                val = val + ':' + newPreprocessor;
                preferences.put("rhq.agent.client.command-preprocessors", val);
            }
        }
    }

    static class Step3to4
    extends PreferencesUpgradeStep {
        Step3to4() {
        }

        public int getSupportedConfigurationSchemaVersion() {
            return 4;
        }

        public void upgrade(Preferences preferences) {
            long val = preferences.getLong("rhq.agent.plugins.availability-scan.period-secs", Long.MAX_VALUE);
            if (val < 300L) {
                preferences.putLong("rhq.agent.plugins.availability-scan.period-secs", 300L);
            }
        }
    }

    static class Step2to3
    extends PreferencesUpgradeStep {
        Step2to3() {
        }

        public int getSupportedConfigurationSchemaVersion() {
            return 3;
        }

        public void upgrade(Preferences preferences) {
            preferences.putLong("rhq.agent.vm-health-check.interval-msecs", 5000L);
            preferences.putFloat("rhq.agent.vm-health-check.low-heap-mem-threshold", 0.9f);
            preferences.putFloat("rhq.agent.vm-health-check.low-nonheap-mem-threshold", 0.9f);
            preferences.putBoolean("rhq.agent.agent-update.enabled", true);
        }
    }

    static class Step1to2
    extends PreferencesUpgradeStep {
        Step1to2() {
        }

        public int getSupportedConfigurationSchemaVersion() {
            return 2;
        }

        public void upgrade(Preferences preferences) {
            preferences.putLong("rhq.agent.primary-server-switchover-check-interval-msecs", 3600000L);
        }
    }
}

