/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.net.MalformedURLException;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.AgentUtils;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.RemoteCommunicator;
import org.rhq.enterprise.communications.command.impl.generic.GenericCommandClient;
import org.rhq.enterprise.communications.command.impl.identify.IdentifyCommand;
import org.rhq.enterprise.communications.command.impl.identify.IdentifyCommandResponse;

public class IdentifyPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.identify", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        IdentifyCommand command = new IdentifyCommand();
        AgentPrintWriter out = agent.getOut();
        try {
            ClientCommandSender sender = agent.getClientCommandSender();
            if (!agent.isStarted() || sender == null) {
                out.println(MSG.getMsg("PromptCommand.identify.not-sending", new Object[0]));
            } else if (args.length <= 1) {
                out.println(MSG.getMsg("PromptCommand.identify.ask-server-for-id", new Object[0]));
                CommandResponse response = sender.sendSynch((Command)command);
                out.println(response);
                if (response instanceof IdentifyCommandResponse && response.isSuccessful()) {
                    long serverTime = ((IdentifyCommandResponse)response).getIdentification().getTimestamp();
                    agent.serverClockNotification(serverTime);
                }
            } else if (args.length > 2) {
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            } else {
                AgentUtils.ServerEndpoint serverEndpoint = AgentUtils.getServerEndpoint(agent.getConfiguration(), args[1]);
                RemoteCommunicator rc = agent.createServerRemoteCommunicator(serverEndpoint.transport, serverEndpoint.namePort.address, serverEndpoint.namePort.port, serverEndpoint.transportParams);
                GenericCommandClient client = new GenericCommandClient(rc);
                out.println(MSG.getMsg("PromptCommand.identify.ask-remote-server-for-id", new Object[]{args[1]}));
                sender.preprocessCommand((Command)command);
                CommandResponse response = client.invoke((Command)command);
                client.disconnectRemoteCommunicator();
                out.println(response);
            }
        }
        catch (MalformedURLException e) {
            out.println(MSG.getMsg("PromptCommand.identify.invalid-locator-uri", new Object[]{args[1]}));
        }
        catch (Throwable e) {
            out.println(MSG.getMsg("PromptCommand.identify.remote-failure", new Object[0]));
            e.printStackTrace(out);
        }
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.identify.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.identify.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.identify.detailed-help", new Object[0]);
    }
}

