/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Set;
import mazz.i18n.Msg;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryFile;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.util.InventoryPrinter;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class InventoryPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.inventory", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        String[] realArgs = new String[args.length - 1];
        System.arraycopy(args, 1, realArgs, 0, args.length - 1);
        this.processCommand(realArgs, agent);
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.inventory.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.inventory.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.inventory.detailed-help", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand(String[] args, AgentMain agent) {
        PrintWriter exportWriter;
        String exportFile;
        block31: {
            int code;
            AgentPrintWriter out = agent.getOut();
            String inventoryBinaryFile = null;
            exportFile = null;
            boolean dumpXml = false;
            boolean dumpTypesOnly = false;
            Integer id = null;
            boolean noRecurse = false;
            String sopts = "-e:i:ntx";
            LongOpt[] lopts = new LongOpt[]{new LongOpt("export", 1, null, 101), new LongOpt("id", 1, null, 105), new LongOpt("norecurse", 0, null, 110), new LongOpt("types", 0, null, 116), new LongOpt("xml", 0, null, 120)};
            Getopt getopt = new Getopt(this.getPromptCommandString(), args, sopts, lopts);
            while (inventoryBinaryFile == null && (code = getopt.getopt()) != -1) {
                switch (code) {
                    case 58: 
                    case 63: {
                        out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                        return;
                    }
                    case 1: {
                        inventoryBinaryFile = getopt.getOptarg();
                        break;
                    }
                    case 101: {
                        exportFile = getopt.getOptarg();
                        break;
                    }
                    case 116: {
                        dumpTypesOnly = true;
                        break;
                    }
                    case 110: {
                        noRecurse = true;
                        break;
                    }
                    case 105: {
                        String idString = getopt.getOptarg();
                        try {
                            id = Integer.valueOf(idString);
                            break;
                        }
                        catch (NumberFormatException e) {
                            out.println(MSG.getMsg("PromptCommand.inventory.bad-id", new Object[]{idString}));
                            return;
                        }
                    }
                    case 120: {
                        dumpXml = true;
                    }
                }
            }
            if (getopt.getOptind() < args.length) {
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                return;
            }
            if (inventoryBinaryFile != null && dumpTypesOnly) {
                out.println(MSG.getMsg("PromptCommand.inventory.dump-types-and-file-specified", new Object[0]));
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                return;
            }
            if (inventoryBinaryFile != null && id != null) {
                out.println(MSG.getMsg("PromptCommand.inventory.id-and-file-specified", new Object[0]));
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                return;
            }
            if (dumpTypesOnly && id != null) {
                out.println(MSG.getMsg("PromptCommand.inventory.id-and-dump-types-specified", new Object[0]));
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                return;
            }
            PluginContainer pc = PluginContainer.getInstance();
            if (!agent.isStarted() || !pc.isStarted()) {
                out.println(MSG.getMsg("PromptCommand.inventory.must-be-started", new Object[0]));
                return;
            }
            exportWriter = out;
            if (exportFile != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(new File(exportFile));
                    exportWriter = new PrintWriter(fos);
                }
                catch (Exception e) {
                    out.println(MSG.getMsg("PromptCommand.inventory.bad-export-file", new Object[]{exportFile, e}));
                    return;
                }
            }
            try {
                if (inventoryBinaryFile == null) {
                    if (dumpTypesOnly) {
                        Set rootTypes = pc.getPluginManager().getMetadataManager().getRootTypes();
                        InventoryPrinter.outputAllResourceTypes((PrintWriter)exportWriter, (boolean)dumpXml, (Set)rootTypes);
                    } else {
                        ResourceContainer rc = null;
                        if (id != null && (rc = pc.getInventoryManager().getResourceContainer(id)) == null) {
                            out.println(MSG.getMsg("PromptCommand.inventory.invalid-resource-id", new Object[]{id}));
                            Object var18_20 = null;
                            if (exportFile != null) {
                                exportWriter.close();
                            }
                            return;
                        }
                        InventoryPrinter.outputInventory((PrintWriter)exportWriter, (!noRecurse ? 1 : 0) != 0, (boolean)dumpXml, (ResourceContainer)rc);
                    }
                    break block31;
                }
                try {
                    InventoryFile file = new InventoryFile(new File(inventoryBinaryFile));
                    file.loadInventory();
                    InventoryPrinter.outputInventory((PrintWriter)exportWriter, (!noRecurse ? 1 : 0) != 0, (boolean)dumpXml, (InventoryFile)file);
                }
                catch (PluginContainerException e) {
                    out.println(MSG.getMsg("PromptCommand.inventory.bad-inventory-file", new Object[]{inventoryBinaryFile, e}));
                }
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                if (exportFile != null) {
                    exportWriter.close();
                }
                throw throwable;
            }
        }
        Object var18_21 = null;
        if (exportFile != null) {
            exportWriter.close();
        }
    }
}

