/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import mazz.i18n.Msg;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class PluginContainerPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.plugin-container", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        if (args.length != 2) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return true;
        }
        if (args[1].equals(MSG.getMsg("PromptCommand.plugin-container.syntax.args.start", new Object[0]))) {
            try {
                if (!agent.isStarted()) {
                    throw new IllegalStateException(MSG.getMsg("AgentMain.cannot-start-pc-agent-shutdown", new Object[0]));
                }
                boolean started = agent.startPluginContainer(60000L);
                if (started) {
                    out.println(MSG.getMsg("PromptCommand.plugin-container.start.done", new Object[0]));
                }
            }
            catch (Exception e) {
                out.println(MSG.getMsg("PromptCommand.plugin-container.error.start", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)}));
            }
        } else if (args[1].equals(MSG.getMsg("PromptCommand.plugin-container.syntax.args.stop", new Object[0]))) {
            try {
                agent.shutdownPluginContainer();
                out.println(MSG.getMsg("PromptCommand.plugin-container.stop.done", new Object[0]));
            }
            catch (Exception e) {
                out.println(MSG.getMsg("PromptCommand.plugin-container.error.stop", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)}));
            }
        } else if (args[1].equals(MSG.getMsg("PromptCommand.plugin-container.syntax.args.status", new Object[0]))) {
            if (agent.isPluginContainerStarted()) {
                out.println(MSG.getMsg("PromptCommand.plugin-container.started", new Object[0]));
            } else {
                out.println(MSG.getMsg("PromptCommand.plugin-container.stopped", new Object[0]));
            }
            out.println(MSG.getMsg("PromptCommand.plugin-container.config", new Object[]{agent.getConfiguration().getPluginContainerConfiguration()}));
        } else {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
        }
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.plugin-container.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.plugin-container.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.plugin-container.detailed-help", new Object[0]);
    }
}

