/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class TimerPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.timer", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        if (args.length == 1) {
            agent.getOut().println(MSG.getMsg("PromptCommand.timer.missing-command", new Object[0]));
            return true;
        }
        boolean ret_val = true;
        String[] cmd_to_execute = new String[args.length - 1];
        System.arraycopy(args, 1, cmd_to_execute, 0, cmd_to_execute.length);
        long free_mem_before = Runtime.getRuntime().freeMemory();
        long total_mem_before = Runtime.getRuntime().totalMemory();
        long time_before = System.currentTimeMillis();
        try {
            ret_val = agent.executePromptCommand(cmd_to_execute);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long time_after = System.currentTimeMillis();
        long free_mem_after = Runtime.getRuntime().freeMemory();
        long total_mem_after = Runtime.getRuntime().totalMemory();
        agent.getOut().println(MSG.getMsg("PromptCommand.timer.results", new Object[]{Float.valueOf((float)(time_after - time_before) / 1000.0f), args[1], Float.valueOf((float)free_mem_before / 1048576.0f), Float.valueOf((float)total_mem_before / 1048576.0f), Float.valueOf((float)free_mem_after / 1048576.0f), Float.valueOf((float)total_mem_after / 1048576.0f)}));
        return ret_val;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.timer.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.timer.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.timer.detailed-help", new Object[0]);
    }
}

