/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.net.MalformedURLException;
import mazz.i18n.Logger;
import org.jboss.remoting.InvokerLocator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.RemoteCommunicator;
import org.rhq.enterprise.communications.command.impl.generic.GenericCommandClient;
import org.rhq.enterprise.communications.command.impl.identify.IdentifyCommand;
import org.rhq.enterprise.communications.command.impl.identify.IdentifyCommandResponse;
import org.rhq.enterprise.communications.command.server.discovery.AutoDiscoveryListener;

public class AgentAutoDiscoveryListener
implements AutoDiscoveryListener {
    private static final Logger LOG = AgentI18NFactory.getLogger(AgentAutoDiscoveryListener.class);
    private final AgentMain m_agent;
    private RemoteCommunicator m_remoteCommunicator;
    private InvokerLocator m_serverToBeListenedFor;
    private boolean m_warnedAboutConnectionFailure;

    public AgentAutoDiscoveryListener(AgentMain agent, RemoteCommunicator communicator) {
        this.m_agent = agent;
        this.m_remoteCommunicator = communicator;
        this.m_serverToBeListenedFor = null;
        this.m_warnedAboutConnectionFailure = false;
    }

    public void serverOnline(InvokerLocator locator) {
        if (this.m_serverToBeListenedFor == null) {
            this.m_serverToBeListenedFor = this.attemptToIdentifyServer();
        }
        if (this.isServerToBeListenedFor(locator)) {
            LOG.info("AgentAutoDiscoveryListener.server-online", new Object[]{locator});
            this.m_agent.getClientCommandSender().startSending();
        }
    }

    public void serverOffline(InvokerLocator locator) {
        if (this.isServerToBeListenedFor(locator)) {
            LOG.info("AgentAutoDiscoveryListener.server-offline", new Object[]{locator});
            this.m_agent.getClientCommandSender().stopSending(false);
        }
    }

    private InvokerLocator attemptToIdentifyServer() {
        try {
            GenericCommandClient client = new GenericCommandClient(this.m_remoteCommunicator);
            CommandResponse genericResponse = client.invoke((Command)new IdentifyCommand());
            IdentifyCommandResponse identifyResponse = new IdentifyCommandResponse(genericResponse);
            if (identifyResponse.getException() != null) {
                throw identifyResponse.getException();
            }
            return new InvokerLocator(identifyResponse.getIdentification().getInvokerLocator());
        }
        catch (Throwable ignore) {
            if (!this.m_warnedAboutConnectionFailure) {
                this.m_warnedAboutConnectionFailure = true;
                LOG.debug("AgentAutoDiscoveryListener.server-id-failure", new Object[]{ThrowableUtil.getAllMessages((Throwable)ignore)});
            }
            return null;
        }
    }

    private boolean isServerToBeListenedFor(InvokerLocator compare_me) {
        InvokerLocator server_locator = this.getServerToBeListenedFor();
        return server_locator.getHost().equals(compare_me.getHost()) && server_locator.getPort() == compare_me.getPort();
    }

    private InvokerLocator getServerToBeListenedFor() {
        InvokerLocator locator;
        if (this.m_serverToBeListenedFor != null) {
            return this.m_serverToBeListenedFor;
        }
        String locator_uri = this.m_agent.getConfiguration().getServerLocatorUri();
        try {
            locator = new InvokerLocator(locator_uri);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(LOG.getMsgString("AgentAutoDiscoveryListener.invalid-locator-uri", new Object[0]), e);
        }
        return locator;
    }
}

