/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.util.Properties;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.enterprise.agent.Version;

public class AgentUpdateInformation {
    private static final String AGENT_UPDATE_BINARY_MD5 = "rhq-agent.latest.md5";
    private static final String AGENT_UPDATE_BINARY_VERSION = "rhq-agent.latest.version";
    private static final String AGENT_UPDATE_BINARY_BUILD = "rhq-agent.latest.build-number";
    private final String agentVersion = Version.getProductVersion();
    private final String agentBuild = Version.getBuildNumber();
    private final String updateVersion;
    private final String updateBuild;
    private final String updateMd5;

    public AgentUpdateInformation(Properties updateProps) {
        if (updateProps != null) {
            this.updateVersion = updateProps.getProperty(AGENT_UPDATE_BINARY_VERSION, "0.UNKNOWN_VERSION");
            this.updateBuild = updateProps.getProperty(AGENT_UPDATE_BINARY_BUILD, "0.UNKNOWN_BUILD");
            this.updateMd5 = updateProps.getProperty(AGENT_UPDATE_BINARY_MD5, "UNKNOWN_MD5");
        } else {
            this.updateVersion = "0.UNKNOWN_VERSION";
            this.updateBuild = "0.UNKNOWN_BUILD";
            this.updateMd5 = "UNKNOWN_MD5";
        }
    }

    public boolean isAgentOutOfDate() {
        ComparableVersion update;
        ComparableVersion agent = new ComparableVersion(this.getAgentVersion());
        return agent.compareTo((Object)(update = new ComparableVersion(this.getUpdateVersion()))) < 0;
    }

    public boolean isAgentOutOfDateStrict() {
        ComparableVersion update;
        ComparableVersion agent = new ComparableVersion(this.getAgentVersion());
        int comparision = agent.compareTo((Object)(update = new ComparableVersion(this.getUpdateVersion())));
        if (comparision == 0) {
            try {
                int agentBuildInt = Integer.parseInt(this.getAgentBuild());
                int updateBuildInt = Integer.parseInt(this.getUpdateBuild());
                return agentBuildInt < updateBuildInt;
            }
            catch (Exception e) {
                return false;
            }
        }
        return comparision < 0;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getAgentBuild() {
        return this.agentBuild;
    }

    public String getUpdateVersion() {
        return this.updateVersion;
    }

    public String getUpdateBuild() {
        return this.updateBuild;
    }

    public String getUpdateMd5() {
        return this.updateMd5;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("AgentUpdateInformation: ");
        str.append("Version=[");
        str.append(this.getUpdateVersion());
        str.append("]; Build=[");
        str.append(this.getUpdateBuild());
        str.append("]");
        return str.toString();
    }
}

