/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.util.Map;
import org.jboss.remoting.InvokerLocator;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.enterprise.agent.AgentConfiguration;

public abstract class AgentUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerEndpoint getServerEndpoint(AgentConfiguration agentConfig, String server) {
        ServerEndpoint serverEndpoint = new ServerEndpoint();
        if (server.indexOf(58) > -1) {
            try {
                InvokerLocator endpointUrl = new InvokerLocator(server);
                String host = endpointUrl.getHost();
                int port = endpointUrl.getPort();
                serverEndpoint.namePort = new FailoverListComposite.ServerEntry(host, port, port);
                serverEndpoint.transport = endpointUrl.getProtocol();
                String path = endpointUrl.getPath();
                Map parameters = endpointUrl.getParameters();
                serverEndpoint.transportParams = "/" + (path != null ? path : "");
                if (parameters == null || parameters.size() <= 0) return serverEndpoint;
                serverEndpoint.transportParams = serverEndpoint.transportParams + "?";
                boolean needAmp = false;
                for (Map.Entry configEntry : parameters.entrySet()) {
                    if (needAmp) {
                        serverEndpoint.transportParams = serverEndpoint.transportParams + "&";
                    }
                    serverEndpoint.transportParams = serverEndpoint.transportParams + configEntry.getKey().toString() + "=" + configEntry.getValue().toString();
                    needAmp = true;
                }
                return serverEndpoint;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            if (agentConfig == null) throw new IllegalArgumentException("agentConfig==null, server==[" + server + ']');
            int currentServerPort = agentConfig.getServerBindPort();
            String currentServerTransport = agentConfig.getServerTransport();
            String currentServerTransportParams = agentConfig.getServerTransportParams();
            serverEndpoint.namePort = new FailoverListComposite.ServerEntry(server, currentServerPort, currentServerPort);
            serverEndpoint.transport = currentServerTransport;
            serverEndpoint.transportParams = currentServerTransportParams;
        }
        return serverEndpoint;
    }

    public static class ServerEndpoint {
        public FailoverListComposite.ServerEntry namePort;
        public String transport;
        public String transportParams;

        public String toString() {
            return this.transport + "://" + this.namePort.address + ":" + this.namePort.port + this.transportParams;
        }
    }
}

