/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.CommandResponseCallback;

class Callback
implements CommandResponseCallback,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Msg MSG = AgentI18NFactory.getMsg();
    private transient AgentMain m_agent = null;

    Callback(AgentMain agent) {
        this.m_agent = agent;
    }

    public void commandSent(CommandResponse response) {
        PrintWriter out = this.m_agent == null ? new PrintWriter(System.out) : this.m_agent.getOut();
        if (response.isSuccessful()) {
            out.println(MSG.getMsg("PromptCommand.ping.timestamped-ping-results", new Object[]{new Date(), response.getResults()}));
        } else {
            out.println(MSG.getMsg("PromptCommand.ping.ping-failed", new Object[]{response.getException()}));
            if (response.getException() != null) {
                response.getException().printStackTrace(out);
            }
        }
        out.flush();
    }
}

