/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.StringUtil;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class HelpPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.help", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        if (args.length <= 1) {
            HashMap<String, String> command_and_help = new HashMap<String, String>();
            for (String command_name : agent.getPromptCommands().keySet()) {
                String help = this.getHelpForCommand(agent, command_name, false);
                command_and_help.put(command_name, help);
            }
            agent.getOut().println(StringUtil.justifyKeyValueStrings(command_and_help));
        } else if (args.length == 2) {
            String command_name = args[1];
            String help = this.getHelpForCommand(agent, command_name, true);
            agent.getOut().println(help);
        } else {
            agent.getOut().println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
        }
        return true;
    }

    private String getHelpForCommand(AgentMain agent, String prompt_command_name, boolean detailed) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        try {
            Class<? extends AgentPromptCommand> clazz = agent.getPromptCommands().get(prompt_command_name);
            AgentPromptCommand cmd_instance = clazz.newInstance();
            if (detailed) {
                ps.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{cmd_instance.getSyntax()}));
                ps.println();
                ps.println(cmd_instance.getDetailedHelp());
            } else {
                ps.print(cmd_instance.getHelp());
            }
        }
        catch (Exception e) {
            ps.print(MSG.getMsg("PromptCommand.help.unknown", new Object[]{prompt_command_name}));
        }
        return out.toString();
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.help.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.help.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.help.detailed-help", new Object[0]);
    }
}

