/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mazz.i18n.Msg;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.clientapi.server.core.CoreServerService;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.PluginUpdate;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.agent.promptcmd.PluginContainerPromptCommand;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientRemotePojoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.plugins", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        if (args.length != 2) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return true;
        }
        try {
            if (args[1].equals(MSG.getMsg("PromptCommand.plugins.syntax.args.update", new Object[0]))) {
                this.doUpdate(agent);
            } else if (args[1].equals(MSG.getMsg("PromptCommand.plugins.syntax.args.info", new Object[0]))) {
                this.doInfo(agent);
            } else {
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            }
        }
        catch (Exception e) {
            out.println(MSG.getMsg("PromptCommand.plugins.error-updating", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)}));
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.plugins.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.plugins.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.plugins.detailed-help", new Object[0]);
    }

    private void doInfo(AgentMain agent) throws Exception {
        AgentPrintWriter out = agent.getOut();
        PluginUpdate plugin_update = this.getPluginUpdateObject(agent);
        List<File> current_plugins = plugin_update.getCurrentPluginFiles();
        List disabled_plugins = plugin_update.getPluginContainerConfiguration().getDisabledPlugins();
        ArrayList<String> installed_plugins = new ArrayList<String>();
        if (current_plugins.size() > 0) {
            out.println(MSG.getMsg("PromptCommand.plugins.listing-plugins-details", new Object[0]));
            for (File current_plugin : current_plugins) {
                String plugin_display_name;
                String plugin_name;
                try {
                    URL url = current_plugin.toURI().toURL();
                    PluginDescriptor descriptor = AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)url);
                    plugin_name = descriptor.getName();
                    plugin_display_name = descriptor.getDisplayName();
                    installed_plugins.add(plugin_name);
                }
                catch (Throwable t) {
                    plugin_name = "?cannot-parse-descriptor?";
                    plugin_display_name = "?cannot-parse-descriptor?";
                }
                String filename = current_plugin.getName();
                Date last_mod = new Date(current_plugin.lastModified());
                long filesize = current_plugin.length();
                String md5 = MessageDigestGenerator.getDigestString((File)current_plugin);
                ((PrintWriter)out).println();
                out.println(MSG.getMsg("PromptCommand.plugins.plugin-info.filename", new Object[]{filename}));
                out.print('\t');
                out.println(MSG.getMsg("PromptCommand.plugins.plugin-info.name", new Object[]{plugin_name}));
                out.print('\t');
                out.println(MSG.getMsg("PromptCommand.plugins.plugin-info.display-name", new Object[]{plugin_display_name}));
                out.print('\t');
                out.println(MSG.getMsg("PromptCommand.plugins.plugin-info.lastmod", new Object[]{last_mod}));
                out.print('\t');
                out.println(MSG.getMsg("PromptCommand.plugins.plugin-info.filesize", new Object[]{filesize}));
                out.print('\t');
                out.println(MSG.getMsg("PromptCommand.plugins.plugin-info.md5", new Object[]{md5}));
            }
            ((PrintWriter)out).println();
            out.println(MSG.getMsg("PromptCommand.plugins.listing-plugins-summary", new Object[]{installed_plugins}));
            if (!disabled_plugins.isEmpty()) {
                ((PrintWriter)out).println();
                out.println(MSG.getMsg("PromptCommand.plugins.listing-plugins-disabled", new Object[]{disabled_plugins}));
            }
            ((PrintWriter)out).println();
            out.println(MSG.getMsg("PromptCommand.plugins.num-current-plugins", new Object[]{current_plugins.size()}));
        } else {
            out.println(MSG.getMsg("PromptCommand.plugins.no-current-plugins", new Object[0]));
        }
    }

    private void doUpdate(AgentMain agent) throws Exception {
        boolean recyclePC = agent.isPluginContainerStarted();
        AgentPrintWriter out = agent.getOut();
        ClientCommandSender clientCommandSender = agent.getClientCommandSender();
        if (clientCommandSender == null || !clientCommandSender.isSending()) {
            out.println(MSG.getMsg("PromptCommand.plugins.error-not-sending", new Object[0]));
            return;
        }
        if (recyclePC) {
            this.executePCCommand(agent, "stop");
        }
        try {
            out.println(MSG.getMsg("PluginUpdate.updating", new Object[0]));
            List<Plugin> updated_plugins = this.updatePlugins(agent);
            if (updated_plugins != null && updated_plugins.size() > 0) {
                for (Plugin plugin : updated_plugins) {
                    if (plugin.isEnabled()) {
                        out.println(MSG.getMsg("PluginUpdate.downloading-complete", new Object[]{plugin.getName(), plugin.getPath()}));
                        continue;
                    }
                    out.println(MSG.getMsg("PluginUpdate.downloading-skipped", new Object[]{plugin.getName()}));
                }
            } else {
                out.println(MSG.getMsg("PluginUpdate.already-uptodate", new Object[0]));
            }
            out.println(MSG.getMsg("PluginUpdate.updating-complete", new Object[0]));
        }
        catch (Throwable t) {
            out.println(MSG.getMsg("AgentMain.plugin-update-failure", new Object[0]));
            out.println(ThrowableUtil.getAllMessages((Throwable)t));
        }
        if (recyclePC) {
            this.executePCCommand(agent, "start");
        }
    }

    private List<Plugin> updatePlugins(AgentMain agent) throws Exception {
        return this.getPluginUpdateObject(agent).updatePlugins();
    }

    private PluginUpdate getPluginUpdateObject(AgentMain agent) {
        ClientCommandSender sender = agent.getClientCommandSender();
        CoreServerService server = null;
        if (sender != null) {
            ClientRemotePojoFactory factory = sender.getClientRemotePojoFactory();
            server = (CoreServerService)factory.getRemotePojo(CoreServerService.class);
        }
        PluginContainerConfiguration pc_config = agent.getConfiguration().getPluginContainerConfiguration();
        PluginUpdate plugin_update = new PluginUpdate(server, pc_config);
        return plugin_update;
    }

    private void executePCCommand(AgentMain agent, String startOrStop) {
        new PluginContainerPromptCommand().execute(agent, new String[]{"pc", startOrStop});
    }
}

