/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.CmdlineClient;

public class RemoteCommandPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.remote", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        try {
            String[] remoteCmdArgs = new String[args.length - 1];
            System.arraycopy(args, 1, remoteCmdArgs, 0, remoteCmdArgs.length);
            CmdlineClient client = new CmdlineClient();
            agent.getOut().println(MSG.getMsg("PromptCommand.remote.issuing", new Object[0]));
            CommandResponse response = client.issueCommand(remoteCmdArgs);
            agent.getOut().println(response);
        }
        catch (Throwable e) {
            throw new RuntimeException(MSG.getMsg("PromptCommand.remote.failure", new Object[0]), e);
        }
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.remote.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.remote.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.remote.detailed-help", new Object[]{new CmdlineClient().getUsage()});
    }
}

