/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import mazz.i18n.Logger;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentUpdateInformation;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;

public class AgentUpdateVersion {
    private static final Logger LOG = AgentI18NFactory.getLogger(AgentUpdateVersion.class);
    private AgentMain agent;
    private AgentUpdateInformation agentUpdateInformation;

    public AgentUpdateVersion(AgentMain agent) {
        this.agent = agent;
        this.agentUpdateInformation = null;
    }

    public URL getVersionUrl() throws Exception {
        return new URL(this.agent.getConfiguration().getAgentUpdateVersionUrl());
    }

    public AgentUpdateInformation getAgentUpdateInformation() throws Exception {
        if (this.agentUpdateInformation == null) {
            this.refresh();
        }
        return this.agentUpdateInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (!this.agent.getConfiguration().isAgentUpdateEnabled()) {
            throw new Exception(this.agent.getI18NMsg().getMsg("AgentUpdateVersion.update-version-disabled-by-agent", new Object[0]));
        }
        Properties versionProps = null;
        URL url = null;
        boolean keep_going = true;
        while (keep_going) {
            HttpURLConnection conn = null;
            InputStream inStream = null;
            try {
                url = this.getVersionUrl();
                LOG.debug("AgentUpdateVersion.update-version-retrieval", new Object[]{url});
                conn = (HttpURLConnection)url.openConnection();
                versionProps = new Properties();
                inStream = conn.getInputStream();
                versionProps.load(inStream);
                keep_going = false;
            }
            catch (Exception e) {
                if (conn != null) {
                    int responseCode = conn.getResponseCode();
                    if (responseCode == 503) {
                        LOG.debug("AgentUpdateVersion.update-version-unavailable", new Object[]{url});
                        Thread.sleep(10000L);
                        keep_going = true;
                        continue;
                    }
                    if (responseCode == 403) {
                        throw new Exception(this.agent.getI18NMsg().getMsg("AgentUpdateVersion.update-version-disabled-by-server", new Object[]{url}));
                    }
                    LOG.warn("AgentUpdateVersion.update-version-failure", new Object[]{url, ThrowableUtil.getAllMessages((Throwable)e)});
                    throw e;
                }
                LOG.warn("AgentUpdateVersion.update-version-failure", new Object[]{url, ThrowableUtil.getAllMessages((Throwable)e)});
                throw e;
            }
            finally {
                if (inStream == null) continue;
                try {
                    inStream.close();
                }
                catch (Exception ioe) {}
            }
        }
        this.agentUpdateInformation = new AgentUpdateInformation(versionProps);
        LOG.debug("AgentUpdateVersion.update-version-retrieved", new Object[]{url, this.agentUpdateInformation});
    }
}

