/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.beans.Introspector;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.List;
import mazz.i18n.Msg;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class GCPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.gc", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        this.processArguments(agent, args);
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.gc.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.gc.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.gc.detailed-help", new Object[0]);
    }

    private void processArguments(AgentMain agent, String[] args) {
        int code;
        AgentPrintWriter out = agent.getOut();
        String sopts = "dfv:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("verbose", 1, null, 118), new LongOpt("dump", 0, null, 100), new LongOpt("free", 0, null, 102)};
        Getopt getopt = new Getopt(this.getPromptCommandString(), args, sopts, lopts);
        Boolean verbose = null;
        Boolean free = null;
        Boolean dump = null;
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 1: 
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    break;
                }
                case 118: {
                    String verboseOpt = getopt.getOptarg();
                    verbose = Boolean.parseBoolean(verboseOpt);
                    break;
                }
                case 100: {
                    dump = Boolean.TRUE;
                    break;
                }
                case 102: {
                    free = Boolean.TRUE;
                }
            }
        }
        if (getopt.getOptind() + 1 < args.length) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
        }
        if (Boolean.TRUE.equals(dump)) {
            this.printCurrentMemoryUsage(out);
        }
        if (verbose != null) {
            this.setVerbosity(verbose);
        }
        if (Boolean.TRUE.equals(free)) {
            this.freeMemory(out);
        }
    }

    private void setVerbosity(boolean verbose) {
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        memoryMxBean.setVerbose(verbose);
    }

    private void freeMemory(PrintWriter out) {
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        this.printGlobalMemoryUsage(out, memoryMxBean);
        Introspector.flushCaches();
        LogFactory.releaseAll();
        out.println(MSG.getMsg("PromptCommand.gc.invoke", new Object[0]));
        memoryMxBean.gc();
        this.printGlobalMemoryUsage(out, memoryMxBean);
    }

    private void printCurrentMemoryUsage(PrintWriter out) {
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        this.printGlobalMemoryUsage(out, memoryMxBean);
        List<MemoryPoolMXBean> poolMxBeans = ManagementFactory.getMemoryPoolMXBeans();
        if (poolMxBeans != null) {
            for (MemoryPoolMXBean bean : poolMxBeans) {
                if (!bean.isValid()) continue;
                String name = bean.getName();
                MemoryType type = bean.getType();
                MemoryUsage usage = bean.getUsage();
                this.printMemoryUsage(out, name, type, usage);
            }
        }
    }

    private void printGlobalMemoryUsage(PrintWriter out, MemoryMXBean memoryMxBean) {
        this.printMemoryUsage(out, "GLOBAL", MemoryType.HEAP, memoryMxBean.getHeapMemoryUsage());
        this.printMemoryUsage(out, "GLOBAL", MemoryType.NON_HEAP, memoryMxBean.getNonHeapMemoryUsage());
    }

    private void printMemoryUsage(PrintWriter out, String name, MemoryType type, MemoryUsage memUsage) {
        String typeStr;
        long init = memUsage.getInit();
        long max = memUsage.getMax();
        long used = memUsage.getUsed();
        long committed = memUsage.getCommitted();
        switch (type) {
            case HEAP: {
                typeStr = "Heap";
                break;
            }
            case NON_HEAP: {
                typeStr = "Non-heap";
                break;
            }
            default: {
                typeStr = "?";
            }
        }
        double usedPercentage = (double)used * 100.0 / (double)committed;
        double committedPercentage = (double)committed * 100.0 / (double)max;
        out.println(MSG.getMsg("PromptCommand.gc.mem-usage", new Object[]{name, typeStr, init, max, used, usedPercentage, committed, committedPercentage}));
    }
}

