/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import mazz.i18n.Logger;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentUpdateInformation;
import org.rhq.enterprise.agent.AgentUpdateVersion;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;

public class AgentUpdateDownload {
    private static final Logger LOG = AgentI18NFactory.getLogger(AgentUpdateDownload.class);
    private final AgentMain agent;
    private final AgentUpdateVersion agentUpdateVersion;
    private File downloadedFile;

    public AgentUpdateDownload(AgentMain agent) {
        this.agent = agent;
        this.agentUpdateVersion = new AgentUpdateVersion(agent);
        this.downloadedFile = null;
    }

    public AgentUpdateVersion getAgentUpdateVersion() {
        return this.agentUpdateVersion;
    }

    public URL getDownloadUrl() throws Exception {
        return new URL(this.agent.getConfiguration().getAgentUpdateDownloadUrl());
    }

    public File getAgentUpdateBinaryFile() {
        return this.downloadedFile;
    }

    public File getLocalDownloadDirectory() {
        String agentHome = this.agent.getAgentHomeDirectory();
        File dir = null;
        if (agentHome != null && agentHome.length() > 0) {
            dir = new File(agentHome).getParentFile();
        }
        if (dir == null) {
            dir = new File(System.getProperty("java.io.tmpdir"));
        }
        return dir;
    }

    public void validate() throws Exception {
        File fileToValidate = this.downloadedFile;
        if (fileToValidate == null || !fileToValidate.exists()) {
            throw new IllegalStateException(this.agent.getI18NMsg().getMsg("AgentUpdateDownload.md5.missing-file", new Object[]{fileToValidate}));
        }
        AgentUpdateInformation info = this.agentUpdateVersion.getAgentUpdateInformation();
        String md5 = info.getUpdateMd5();
        if (!this.validateFile(this.downloadedFile, md5)) {
            File invalidFile = new File(fileToValidate.getParentFile(), fileToValidate.getName() + ".invalid");
            invalidFile.delete();
            fileToValidate.renameTo(invalidFile);
            throw new IllegalStateException(this.agent.getI18NMsg().getMsg("AgentUpdateDownload.md5.invalid", new Object[]{fileToValidate}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void download() throws Exception {
        if (!this.agent.getConfiguration().isAgentUpdateEnabled()) {
            throw new Exception(this.agent.getI18NMsg().getMsg("AgentUpdateDownload.update-download-disabled-by-agent", new Object[0]));
        }
        info = this.agentUpdateVersion.getAgentUpdateInformation();
        url = null;
        keep_going = true;
        binaryFile = null;
        while (keep_going) {
            block32: {
                block29: {
                    block27: {
                        block28: {
                            conn = null;
                            inStream = null;
                            try {
                                try {
                                    url = this.getDownloadUrl();
                                    AgentUpdateDownload.LOG.info("AgentUpdateDownload.update-download-retrieval", new Object[]{info, url});
                                    conn = (HttpURLConnection)url.openConnection();
                                    inStream = conn.getInputStream();
                                    fileName = conn.getHeaderField("Content-Disposition");
                                    if (fileName != null) {
                                        filenameIndex = fileName.indexOf("filename=");
                                        if (filenameIndex > -1 && filenameIndex + "filename=".length() < fileName.length()) {
                                            fileName = fileName.substring(filenameIndex + "filename=".length()).trim();
                                        } else {
                                            AgentUpdateDownload.LOG.warn("AgentUpdateDownload.update-download-bad-name", new Object[]{fileName});
                                            fileName = null;
                                        }
                                    }
                                    if (fileName == null || fileName.length() == 0) {
                                        fileName = "rhq-enterprise-agent-" + info.getUpdateVersion() + ".jar";
                                        AgentUpdateDownload.LOG.info("AgentUpdateDownload.update-download-no-name", new Object[]{fileName});
                                    }
                                    if (this.validateFile(binaryFile = new File(dir = this.getLocalDownloadDirectory(), fileName), info.getUpdateMd5())) {
                                        AgentUpdateDownload.LOG.debug("AgentUpdateDownload.update-download-already-have-it", new Object[]{binaryFile});
                                        keep_going = false;
                                        var11_14 = null;
                                        if (inStream == null) break block27;
                                        break block28;
                                    }
                                    binaryFile.delete();
                                    fos = new FileOutputStream(binaryFile);
                                    StreamUtil.copy((InputStream)inStream, (OutputStream)fos, (boolean)true);
                                    inStream = null;
                                    keep_going = false;
                                    break block29;
                                }
                                catch (Exception e) {
                                    block30: {
                                        block34: {
                                            block33: {
                                                if (conn == null) {
                                                    AgentUpdateDownload.LOG.warn("AgentUpdateDownload.update-download-failure", new Object[]{url, ThrowableUtil.getAllMessages((Throwable)e)});
                                                    throw e;
                                                }
                                                responseCode = 0;
                                                try {
                                                    responseCode = conn.getResponseCode();
                                                }
                                                catch (Exception ignore) {
                                                    // empty catch block
                                                }
                                                if (responseCode != 503) break block33;
                                                AgentUpdateDownload.LOG.info("AgentUpdateDownload.update-download-unavailable", new Object[]{info, url});
                                                Thread.sleep(this.getRetryAfter(conn));
                                                keep_going = true;
                                                var11_14 = null;
                                                if (inStream == null) break block30;
                                                break block34;
                                            }
                                            if (responseCode == 403) {
                                                e1 = new Exception(this.agent.getI18NMsg().getMsg("AgentUpdateDownload.update-download-disabled-by-server", new Object[]{url}), e);
                                                AgentUpdateDownload.LOG.warn("AgentUpdateDownload.update-download-failure", new Object[]{url, ThrowableUtil.getAllMessages((Throwable)e1)});
                                                throw e1;
                                            }
                                            AgentUpdateDownload.LOG.warn("AgentUpdateDownload.update-download-failure", new Object[]{url, ThrowableUtil.getAllMessages((Throwable)e)});
                                            throw e;
                                        }
                                        try {
                                            inStream.close();
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                    if (conn == null) continue;
                                    try {
                                        conn.disconnect();
                                    }
                                    catch (Exception e) {}
                                    continue;
                                }
                            }
                            catch (Throwable var10_16) {
                                block31: {
                                    var11_14 = null;
                                    if (inStream != null) {
                                        ** try [egrp 3[TRYBLOCK] [7 : 558->566)] { 
lbl92:
                                        // 1 sources

                                        inStream.close();
                                        break block31;
lbl94:
                                        // 1 sources

                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (conn == null) throw var10_16;
                                ** try [egrp 4[TRYBLOCK] [8 : 573->581)] { 
lbl99:
                                // 1 sources

                                conn.disconnect();
                                throw var10_16;
lbl101:
                                // 1 sources

                                catch (Exception e) {
                                    // empty catch block
                                }
                                throw var10_16;
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [7 : 558->566)] { 
lbl106:
                        // 1 sources

                        inStream.close();
                        break block27;
lbl108:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (conn == null) break;
                    try {}
                    catch (Exception e) {}
                    conn.disconnect();
                    break;
                }
                var11_14 = null;
                if (inStream != null) {
                    ** try [egrp 3[TRYBLOCK] [7 : 558->566)] { 
lbl121:
                    // 1 sources

                    inStream.close();
                    break block32;
lbl123:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (conn == null) continue;
            try {}
            catch (Exception e) {}
            conn.disconnect();
        }
        AgentUpdateDownload.LOG.info("AgentUpdateDownload.update-download-done", new Object[]{info, url, binaryFile});
        this.downloadedFile = binaryFile;
    }

    private long getRetryAfter(HttpURLConnection conn) {
        try {
            int retryAfter = conn.getHeaderFieldInt("Retry-After", 30);
            return 1000L * (long)retryAfter;
        }
        catch (Exception e) {
            return 30000L;
        }
    }

    private boolean validateFile(File file, String md5) {
        try {
            String filemd5 = MessageDigestGenerator.getDigestString((File)file);
            return filemd5 != null && filemd5.equals(md5);
        }
        catch (Exception e) {
            return false;
        }
    }
}

