/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.rhq.enterprise.agent.JavaServiceWrapperConfigurationFileUpdate;
import org.rhq.enterprise.agent.JavaServiceWrapperEnvironmentScriptFileUpdate;
import org.rhq.enterprise.agent.UnixEnvironmentScriptFileUpdate;
import org.rhq.enterprise.agent.WindowsEnvironmentScriptFileUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnvironmentScriptFileUpdate {
    private File file;

    public static EnvironmentScriptFileUpdate create(String location) {
        if (location.endsWith(".env")) {
            return new JavaServiceWrapperEnvironmentScriptFileUpdate(location);
        }
        if (location.endsWith(".inc") || location.endsWith(".conf")) {
            return new JavaServiceWrapperConfigurationFileUpdate(location);
        }
        if (location.endsWith(".bat") || location.endsWith(".cmd")) {
            return new WindowsEnvironmentScriptFileUpdate(location);
        }
        return new UnixEnvironmentScriptFileUpdate(location);
    }

    public EnvironmentScriptFileUpdate(String location) {
        this.file = new File(location);
    }

    public void update(NameValuePair nvp) throws IOException {
        List<NameValuePair> existingList;
        Properties existing;
        if (nvp.value == null) {
            nvp.value = "";
        }
        if (!(existing = this.convertNameValuePairListToProperties(existingList = this.loadExisting())).containsKey(nvp.name)) {
            PrintStream ps = new PrintStream(new FileOutputStream(this.file, true), true);
            ps.println();
            ps.println(this.createEnvironmentVariableLine(nvp));
            ps.flush();
            ps.close();
        } else if (!nvp.value.equals(existing.getProperty(nvp.name))) {
            ArrayList<NameValuePair> newList = new ArrayList<NameValuePair>();
            newList.add(nvp);
            this.update(newList, false);
        }
    }

    public void update(List<NameValuePair> newValuesList, boolean deleteMissing) throws IOException {
        Properties newValues = this.convertNameValuePairListToProperties(newValuesList);
        Properties settingsToUpdate = new Properties();
        settingsToUpdate.putAll((Map<?, ?>)newValues);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos, true);
        if (this.file.exists()) {
            List<NameValuePair> existingList = this.loadExisting();
            Properties existing = this.convertNameValuePairListToProperties(existingList);
            for (Map.Entry<Object, Object> entry : newValues.entrySet()) {
                if (!entry.getValue().equals(existing.get(entry.getKey()))) continue;
                settingsToUpdate.remove(entry.getKey());
            }
            InputStreamReader isr = new InputStreamReader(new FileInputStream(this.file));
            BufferedReader in = new BufferedReader(isr);
            String line = in.readLine();
            while (line != null) {
                NameValuePair nameValue = this.parseEnvironmentVariableLine(line);
                if (nameValue == null) {
                    out.println(line);
                } else {
                    String existingKey = nameValue.name;
                    if (!settingsToUpdate.containsKey(existingKey)) {
                        if (!deleteMissing || newValues.getProperty(existingKey) != null) {
                            out.println(line);
                        }
                    } else {
                        NameValuePair newNvp = new NameValuePair(existingKey, settingsToUpdate.getProperty(existingKey));
                        out.println(this.createEnvironmentVariableLine(newNvp));
                        settingsToUpdate.remove(existingKey);
                    }
                }
                line = in.readLine();
            }
            in.close();
        }
        for (Map.Entry<Object, Object> entry : settingsToUpdate.entrySet()) {
            NameValuePair nvp = new NameValuePair(entry.getKey().toString(), entry.getValue().toString());
            out.println(this.createEnvironmentVariableLine(nvp));
        }
        out.close();
        FileOutputStream fos = new FileOutputStream(this.file, false);
        fos.write(baos.toByteArray());
        fos.flush();
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NameValuePair> loadExisting() throws IOException {
        ArrayList<NameValuePair> props = new ArrayList<NameValuePair>();
        if (this.file.exists()) {
            BufferedReader in = new BufferedReader(new FileReader(this.file));
            try {
                String line = in.readLine();
                while (line != null) {
                    NameValuePair nvp = this.parseEnvironmentVariableLine(line);
                    if (nvp != null) {
                        props.add(nvp);
                    }
                    line = in.readLine();
                }
            }
            finally {
                in.close();
            }
        }
        return props;
    }

    public Properties convertNameValuePairListToProperties(List<NameValuePair> list) {
        Properties props = new Properties();
        if (list != null) {
            for (NameValuePair nvp : list) {
                props.setProperty(nvp.name, nvp.value);
            }
        }
        return props;
    }

    public List<NameValuePair> convertPropertiesToNameValuePairList(Properties props) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (props != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                list.add(new NameValuePair(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
        return list;
    }

    protected abstract String createEnvironmentVariableLine(NameValuePair var1);

    protected abstract NameValuePair parseEnvironmentVariableLine(String var1);

    public static class NameValuePair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name;
        public String value;

        public NameValuePair(String n, String v) {
            if (n == null) {
                throw new IllegalArgumentException("n == null");
            }
            this.name = n;
            this.value = v;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NameValuePair) {
                return this.name.equals(((NameValuePair)obj).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

