/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.w3c.dom.Document;

public class ConfigPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.config", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        try {
            AgentConfiguration agent_config = agent.getConfiguration();
            Preferences preferences = agent_config.getPreferences();
            if (args.length != 2 && args.length != 3) {
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            } else if (args.length == 2) {
                if (args[1].equals(MSG.getMsg("PromptCommand.config.list", new Object[0]))) {
                    out.println(this.getPreferencesXml(preferences));
                } else {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                }
            } else if (args[1].equals(MSG.getMsg("PromptCommand.config.import", new Object[0]))) {
                String importFile = args[2];
                agent.loadConfigurationFile(importFile);
                out.println(MSG.getMsg("PromptCommand.config.import.config-imported", new Object[0]) + importFile);
            } else if (args[1].equals(MSG.getMsg("PromptCommand.config.export", new Object[0]))) {
                String exportFileString = args[2];
                File exportFile = new File(exportFileString);
                PrintWriter pw = new PrintWriter(new FileOutputStream(exportFile));
                pw.write(this.getPreferencesXml(preferences));
                pw.close();
                out.println(MSG.getMsg("PromptCommand.config.export.config-exported", new Object[0]) + exportFile);
            } else {
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            }
        }
        catch (Exception e) {
            out.println(MSG.getMsg("PromptCommand.config.failure", new Object[0]));
            e.printStackTrace(out);
        }
        return true;
    }

    public String getSyntax() {
        return MSG.getMsg("PromptCommand.config.syntax", new Object[0]);
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.config.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.config.detailed-help", new Object[0]);
    }

    private String getPreferencesXml(Preferences preferences) throws Exception {
        ByteArrayOutputStream unformatted = new ByteArrayOutputStream();
        preferences.exportSubtree(unformatted);
        String prefs = unformatted.toString();
        int start = prefs.indexOf("<!DOCTYPE");
        int end = prefs.indexOf(">", start);
        String filteredPrefs = prefs.substring(0, start);
        filteredPrefs = filteredPrefs + prefs.substring(end + 1);
        ByteArrayInputStream bais = new ByteArrayInputStream(filteredPrefs.getBytes());
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.parse(bais);
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(output);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        return output.toString();
    }
}

