/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import mazz.i18n.Logger;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.RemoteCommunicator;
import org.rhq.enterprise.communications.command.impl.identify.IdentifyCommand;
import org.rhq.enterprise.communications.util.NotProcessedException;
import org.rhq.enterprise.communications.util.SecurityUtil;

public class PrimaryServerSwitchoverThread
extends Thread {
    private static final Logger LOG = AgentI18NFactory.getLogger(AgentMain.class);
    private final AgentMain agent;
    private long interval = 3600000L;
    private volatile boolean toldToStop = false;

    public PrimaryServerSwitchoverThread(AgentMain agent) {
        super("RHQ Primary Server Switchover Thread");
        this.setDaemon(true);
        this.agent = agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("PrimaryServerSwitchoverThread.started", new Object[0]);
        while (!this.isInterrupted() && !this.toldToStop) {
            try {
                FailoverListComposite failoverList;
                ClientCommandSender sender = this.agent.getClientCommandSender();
                if (sender.isSending() && (failoverList = this.agent.downloadServerFailoverList()).size() > 0) {
                    int primaryPort;
                    AgentConfiguration config = this.agent.getConfiguration();
                    String transport = config.getServerTransport();
                    String transportParams = config.getServerTransportParams();
                    String currentServerAddress = config.getServerBindAddress();
                    int currentServerPort = config.getServerBindPort();
                    FailoverListComposite.ServerEntry primary = failoverList.get(0);
                    String primaryAddress = primary.address;
                    int n = primaryPort = SecurityUtil.isTransportSecure((String)transport) ? primary.securePort : primary.port;
                    if (!primaryAddress.equals(currentServerAddress) || primaryPort != currentServerPort) {
                        LOG.info("PrimaryServerSwitchoverThread.not-talking-to-primary", new Object[]{primaryAddress, primaryPort, currentServerAddress, currentServerPort});
                        RemoteCommunicator comm = this.agent.createServerRemoteCommunicator(transport, primaryAddress, primaryPort, transportParams);
                        if (this.ping(comm)) {
                            LOG.info("PrimaryServerSwitchoverThread.primary-up", new Object[]{primaryAddress, primaryPort});
                            failoverList.resetIndex();
                            this.agent.failoverToNewServer(sender.getRemoteCommunicator());
                        } else {
                            LOG.info("PrimaryServerSwitchoverThread.primary-still-down", new Object[]{primaryAddress, primaryPort});
                        }
                    }
                }
                PrimaryServerSwitchoverThread primaryServerSwitchoverThread = this;
                synchronized (primaryServerSwitchoverThread) {
                    this.wait(this.interval);
                }
            }
            catch (InterruptedException ie) {
                break;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, "PrimaryServerSwitchoverThread.exception", new Object[]{e});
            }
        }
        LOG.info("PrimaryServerSwitchoverThread.stopped", new Object[0]);
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void stopChecking() {
        this.toldToStop = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNow() {
        PrimaryServerSwitchoverThread primaryServerSwitchoverThread = this;
        synchronized (primaryServerSwitchoverThread) {
            this.notifyAll();
        }
    }

    private boolean ping(RemoteCommunicator comm) {
        boolean ok = true;
        IdentifyCommand id_cmd = new IdentifyCommand();
        this.agent.getClientCommandSender().preprocessCommand((Command)id_cmd);
        try {
            CommandResponse response = comm.sendWithoutCallbacks((Command)id_cmd);
            if (response.getException() instanceof NotProcessedException) {
                ok = false;
            }
        }
        catch (Throwable e) {
            ok = false;
        }
        return ok;
    }
}

