/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SecureConnector {
    private final String secureSocketProtocol;
    private final File truststoreFile;
    private final String truststorePassword;
    private final String truststoreType;
    private final String truststoreAlgorithm;
    private static TrustManager NO_OP_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    };
    private static HostnameVerifier NO_OP_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    };

    public SecureConnector(String secureSocketProtocol) {
        this(secureSocketProtocol, null, null, null, null);
    }

    public SecureConnector(String secureSocketProtocol, File truststoreFile, String truststorePassword, String truststoreType, String truststoreAlgorithm) {
        if (secureSocketProtocol == null) {
            throw new IllegalArgumentException("secure socket protocol cannot be null");
        }
        this.secureSocketProtocol = secureSocketProtocol;
        if (truststoreFile == null) {
            this.truststoreFile = null;
            this.truststorePassword = null;
            this.truststoreType = null;
            this.truststoreAlgorithm = null;
        } else {
            this.truststoreFile = truststoreFile;
            if (truststorePassword == null) {
                throw new IllegalArgumentException("truststorePassword cannot be null");
            }
            this.truststorePassword = truststorePassword;
            if (truststoreType == null) {
                truststoreType = KeyStore.getDefaultType();
            }
            this.truststoreType = truststoreType;
            if (truststoreAlgorithm == null) {
                truststoreAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            this.truststoreAlgorithm = truststoreAlgorithm;
        }
    }

    public HttpsURLConnection openSecureConnection(URL url) throws Exception {
        TrustManager[] trustManagers;
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        SSLContext sslContext = SSLContext.getInstance(this.getSecureSocketProtocol());
        if (this.getTruststoreFile() == null) {
            trustManagers = new TrustManager[]{NO_OP_TRUST_MANAGER};
            connection.setHostnameVerifier(NO_OP_HOSTNAME_VERIFIER);
        } else {
            KeyStore keyStore = KeyStore.getInstance(this.getTruststoreType());
            keyStore.load(new FileInputStream(this.getTruststoreFile()), this.getTruststorePassword().toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.getTruststoreAlgorithm());
            tmf.init(keyStore);
            trustManagers = tmf.getTrustManagers();
        }
        sslContext.init(null, trustManagers, null);
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
        return connection;
    }

    public String getSecureSocketProtocol() {
        return this.secureSocketProtocol;
    }

    public File getTruststoreFile() {
        return this.truststoreFile;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public String getTruststoreAlgorithm() {
        return this.truststoreAlgorithm;
    }

    public static void main(String[] args) throws Exception {
        HttpsURLConnection conn = new SecureConnector("TLS").openSecureConnection(new URL(args[0]));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedInputStream input = new BufferedInputStream(conn.getInputStream(), 32768);
        byte[] buffer = new byte[32768];
        int bytesRead = ((InputStream)input).read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            bytesRead = ((InputStream)input).read(buffer);
        }
        out.flush();
        System.out.println(out.toString());
    }
}

