/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import org.rhq.enterprise.agent.EnvironmentScriptFileUpdate;

public class WindowsEnvironmentScriptFileUpdate
extends EnvironmentScriptFileUpdate {
    public WindowsEnvironmentScriptFileUpdate(String location) {
        super(location);
    }

    @Override
    protected String createEnvironmentVariableLine(EnvironmentScriptFileUpdate.NameValuePair nvp) {
        return "set " + nvp.name + "=" + nvp.value;
    }

    @Override
    protected EnvironmentScriptFileUpdate.NameValuePair parseEnvironmentVariableLine(String line) {
        if (line == null || !line.contains("=")) {
            return null;
        }
        String trimmed = line.trim();
        if (trimmed.startsWith("@")) {
            trimmed = trimmed.substring(1).trim();
        }
        if (!trimmed.startsWith("set ")) {
            return null;
        }
        trimmed = trimmed.substring(4).trim();
        String[] nameValue = trimmed.split("=", 2);
        return new EnvironmentScriptFileUpdate.NameValuePair(nameValue[0], nameValue[1]);
    }
}

