/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import mazz.i18n.Msg;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.agent.metadata.ResourceTypeNotEnabledException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.inventory.RuntimeDiscoveryExecutor;
import org.rhq.core.pc.plugin.PluginComponentFactory;
import org.rhq.core.pc.util.DiscoveryComponentProxyFactory;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.PluginContainerDeployment;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.system.pquery.ProcessInfoQuery;
import org.rhq.core.util.exception.ExceptionPackage;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class DiscoveryPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.discovery", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        if (PluginContainer.getInstance().isStarted()) {
            String[] realArgs = new String[args.length - 1];
            System.arraycopy(args, 1, realArgs, 0, args.length - 1);
            this.processCommand(agent, realArgs, out);
        } else {
            out.println(MSG.getMsg("PromptCommand.discovery.pc-not-started", new Object[0]));
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.discovery.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.discovery.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.discovery.detailed-help", new Object[0]);
    }

    private void processCommand(AgentMain agent, String[] args, PrintWriter out) {
        int code;
        AgentConfiguration agentConfig = agent.getConfiguration();
        String pcName = agentConfig.getAgentName();
        String pluginName = null;
        String resourceTypeName = null;
        Integer resourceId = null;
        boolean verbose = false;
        boolean full = false;
        String sopts = "-p:i:r:fvb:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("plugin", 1, null, 112), new LongOpt("resourceId", 1, null, 105), new LongOpt("resourceType", 1, null, 114), new LongOpt("full", 0, null, 102), new LongOpt("verbose", 0, null, 118), new LongOpt("blacklist", 1, null, 98)};
        Getopt getopt = new Getopt("discovery", args, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 1: 
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    return;
                }
                case 112: {
                    pluginName = getopt.getOptarg();
                    break;
                }
                case 105: {
                    resourceId = Integer.valueOf(getopt.getOptarg());
                    break;
                }
                case 114: {
                    resourceTypeName = getopt.getOptarg();
                    break;
                }
                case 102: {
                    full = true;
                    break;
                }
                case 98: {
                    String opt = getopt.getOptarg();
                    InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
                    DiscoveryComponentProxyFactory factory = inventoryManager.getDiscoveryComponentProxyFactory();
                    if (opt.equalsIgnoreCase("list")) {
                        HashSet blacklist = factory.getResourceTypeBlacklist();
                        out.println(MSG.getMsg("PromptCommand.discovery.blacklist.list", new Object[]{blacklist}));
                    } else if (opt.equalsIgnoreCase("clear")) {
                        factory.clearResourceTypeBlacklist();
                        out.println(MSG.getMsg("PromptCommand.discovery.blacklist.clear", new Object[0]));
                    } else {
                        out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    }
                    return;
                }
                case 118: {
                    verbose = true;
                }
            }
        }
        if (getopt.getOptind() + 1 < args.length) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return;
        }
        if (full) {
            InventoryManager inventoryManager;
            if (!agent.getClientCommandSender().isSending()) {
                out.println(MSG.getMsg("PromptCommand.discovery.agent-not-connected-to-server", new Object[0]));
            }
            if ((inventoryManager = PluginContainer.getInstance().getInventoryManager()).isDiscoveryScanInProgress()) {
                out.println(MSG.getMsg("PromptCommand.discovery.scan-already-in-progress", new Object[0]));
                return;
            }
            HashSet blacklist = inventoryManager.getDiscoveryComponentProxyFactory().getResourceTypeBlacklist();
            if (!blacklist.isEmpty()) {
                out.println(MSG.getMsg("PromptCommand.discovery.blacklisted-types", new Object[]{blacklist}));
            }
            long start = System.currentTimeMillis();
            InventoryReport scan1 = inventoryManager.executeServerScanImmediately();
            InventoryReport scan2 = inventoryManager.executeServiceScanImmediately();
            out.println(MSG.getMsg("PromptCommand.discovery.full-run", new Object[]{System.currentTimeMillis() - start}));
            this.printInventoryReport(scan1, out, verbose);
            this.printInventoryReport(scan2, out, verbose);
        } else {
            try {
                if (resourceId == null) {
                    this.discovery(pcName, out, pluginName, resourceTypeName, verbose);
                } else {
                    InventoryManager im = PluginContainer.getInstance().getInventoryManager();
                    ResourceContainer resourceContainer = im.getResourceContainer(resourceId.intValue());
                    if (resourceContainer != null) {
                        Resource resource = resourceContainer.getResource();
                        PluginContainerConfiguration pcc = agentConfig.getPluginContainerConfiguration();
                        RuntimeDiscoveryExecutor scanner = new RuntimeDiscoveryExecutor(im, pcc, resource);
                        InventoryReport report = scanner.call();
                        out.println(MSG.getMsg("PromptCommand.discovery.resource-service-scan", new Object[]{resource.getName()}));
                        this.printInventoryReport(report, out, verbose);
                    } else {
                        out.println(MSG.getMsg("PromptCommand.discovery.resource-id-invalid", new Object[]{resourceId}));
                    }
                }
            }
            catch (Exception e) {
                out.println(MSG.getMsg("PromptCommand.discovery.error", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)}));
            }
        }
    }

    private void discovery(String pcName, PrintWriter out, String pluginName, String resourceTypeName, boolean verbose) throws Exception {
        PluginContainer pc = PluginContainer.getInstance();
        PluginMetadataManager metadataManager = pc.getPluginManager().getMetadataManager();
        TreeSet<ResourceType> typesToDiscover = new TreeSet<ResourceType>(new PluginPrimaryResourceTypeComparator());
        Set allPlugins = metadataManager.getPluginNames();
        if (pluginName != null && !allPlugins.contains(pluginName)) {
            out.println(MSG.getMsg("PromptCommand.discovery.bad-plugin-name", new Object[]{pluginName}));
            return;
        }
        Set allTypes = metadataManager.getAllTypes();
        if (resourceTypeName != null) {
            for (ResourceType type : allTypes) {
                if (!type.getName().equals(resourceTypeName) || pluginName != null && !pluginName.equals(type.getPlugin())) continue;
                typesToDiscover.add(type);
            }
        } else if (pluginName != null) {
            for (ResourceType type : allTypes) {
                if (!pluginName.equals(type.getPlugin())) continue;
                typesToDiscover.add(type);
            }
        } else {
            typesToDiscover.addAll(allTypes);
        }
        if (typesToDiscover.size() == 0) {
            if (pluginName == null) {
                out.println(MSG.getMsg("PromptCommand.discovery.bad-resource-type-name", new Object[]{resourceTypeName}));
            } else {
                out.println(MSG.getMsg("PromptCommand.discovery.bad-plugin-resource-type-name", new Object[]{pluginName, resourceTypeName}));
            }
            return;
        }
        InventoryManager inventoryManager = pc.getInventoryManager();
        HashSet blacklist = inventoryManager.getDiscoveryComponentProxyFactory().getResourceTypeBlacklist();
        Iterator iterator = blacklist.iterator();
        while (iterator.hasNext()) {
            ResourceType type = (ResourceType)iterator.next();
            if (typesToDiscover.contains(type)) continue;
            iterator.remove();
        }
        if (!blacklist.isEmpty()) {
            out.println(MSG.getMsg("PromptCommand.discovery.blacklisted-types", new Object[]{blacklist}));
        }
        for (ResourceType typeToDiscover : typesToDiscover) {
            if (!typeToDiscover.getCategory().equals((Object)ResourceCategory.SERVER) || typeToDiscover.getParentResourceTypes().size() != 0) continue;
            out.println(MSG.getMsg("PromptCommand.discovery.discovering-resource-type", new Object[]{typeToDiscover.getPlugin(), typeToDiscover.getName()}));
            this.discoveryForSingleResourceType(pcName, out, typeToDiscover, verbose);
            out.println(MSG.getMsg("PromptCommand.discovery.discovering-resource-type-done", new Object[]{typeToDiscover.getPlugin(), typeToDiscover.getName()}));
            out.println();
        }
    }

    private void discoveryForSingleResourceType(String pcName, PrintWriter out, ResourceType resourceType, boolean verbose) {
        try {
            ResourceDiscoveryContext context;
            ArrayList<ProcessScanResult> scanResults = new ArrayList<ProcessScanResult>();
            SystemInfo systemInfo = SystemInfoFactory.createSystemInfo();
            Set processScans = resourceType.getProcessScans();
            if (processScans != null && processScans.size() > 0) {
                try {
                    ProcessInfoQuery piq = new ProcessInfoQuery(systemInfo.getAllProcesses());
                    if (processScans != null) {
                        for (ProcessScan processScan : processScans) {
                            List queryResults = piq.query(processScan.getQuery());
                            if (queryResults == null || queryResults.size() <= 0) continue;
                            for (ProcessInfo autoDiscoveredProcess : queryResults) {
                                scanResults.add(new ProcessScanResult(processScan, autoDiscoveredProcess));
                                out.println(MSG.getMsg("PromptCommand.discovery.process-scan", new Object[]{resourceType.getPlugin(), resourceType.getName(), processScan, autoDiscoveredProcess}));
                            }
                        }
                    }
                }
                catch (UnsupportedOperationException uoe) {
                    // empty catch block
                }
            }
            PluginComponentFactory componentFactory = PluginContainer.getInstance().getPluginComponentFactory();
            InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
            ResourceContainer platformContainer = inventoryManager.getResourceContainer(inventoryManager.getPlatform());
            ResourceComponent platformComponent = inventoryManager.getResourceComponent(inventoryManager.getPlatform());
            ResourceDiscoveryComponent discoveryComponent = componentFactory.getDiscoveryComponent(resourceType, platformContainer);
            Set discoveredResources = inventoryManager.invokeDiscoveryComponent(platformContainer, discoveryComponent, context = new ResourceDiscoveryContext(resourceType, platformComponent, platformContainer.getResourceContext(), systemInfo, scanResults, Collections.EMPTY_LIST, pcName, PluginContainerDeployment.AGENT));
            if (discoveredResources != null) {
                for (DiscoveredResourceDetails discoveredResource : discoveredResources) {
                    out.println(MSG.getMsg("PromptCommand.discovery.component-result", new Object[]{discoveredResource.getResourceType().getPlugin(), discoveredResource.getResourceType().getName(), discoveredResource.getResourceKey(), discoveredResource.getResourceName(), discoveredResource.getResourceVersion(), discoveredResource.getResourceDescription()}));
                    if (!verbose) continue;
                    this.printConfiguration(discoveredResource.getPluginConfiguration(), out);
                }
            }
        }
        catch (ResourceTypeNotEnabledException rtne) {
        }
        catch (Throwable t) {
            out.println(ThrowableUtil.getAllMessages((Throwable)t));
        }
    }

    private void printConfiguration(Configuration config, PrintWriter out) {
        for (Property property : config.getMap().values()) {
            StringBuilder builder = new StringBuilder();
            builder.append("    ");
            builder.append(property.getName());
            builder.append("=");
            if (property instanceof PropertySimple) {
                String value = ((PropertySimple)property).getStringValue();
                builder.append(value != null ? "\"" + value + "\"" : value);
            } else {
                builder.append(property);
            }
            out.println(builder);
        }
    }

    private void printInventoryReport(InventoryReport report, PrintWriter out, boolean verbose) {
        long start = report.getStartTime();
        long end = report.getEndTime();
        boolean isServiceScan = report.isRuntimeReport();
        int count = report.getResourceCount();
        Set roots = report.getAddedRoots();
        List errors = report.getErrors();
        out.println(MSG.getMsg("PromptCommand.discovery.inventory-report-summary", new Object[]{isServiceScan ? "Service Scan" : "Server Scan", new Date(start), new Date(end), count}));
        if (verbose) {
            if (roots != null) {
                for (Resource resource : roots) {
                    out.println(MSG.getMsg("PromptCommand.discovery.inventory-report-resource", new Object[]{resource}));
                }
            }
            if (errors != null) {
                for (ExceptionPackage error : errors) {
                    out.println(MSG.getMsg("PromptCommand.discovery.inventory-report-error", new Object[]{error.getAllMessages()}));
                }
            }
        }
        out.println();
    }

    private class PluginPrimaryResourceTypeComparator
    implements Comparator<ResourceType> {
        private PluginPrimaryResourceTypeComparator() {
        }

        @Override
        public int compare(ResourceType type1, ResourceType type2) {
            int result;
            if (type1.getPlugin() == null) {
                return type2.getPlugin() == null ? 0 : -1;
            }
            int n = result = type2.getPlugin() == null ? 1 : type1.getPlugin().compareTo(type2.getPlugin());
            if (result != 0) {
                return result;
            }
            if (type1.getName() == null) {
                return type2.getName() == null ? 0 : -1;
            }
            return type2.getName() == null ? 1 : type1.getName().compareTo(type2.getName());
        }
    }
}

