/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import mazz.i18n.Msg;
import org.rhq.core.clientapi.server.core.CoreServerService;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientRemotePojoFactory;

public class DownloadPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.download", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        String file_to_download = null;
        try {
            File storage_dir;
            if (args.length == 2) {
                storage_dir = agent.getConfiguration().getDataDirectory();
            } else if (args.length == 3) {
                storage_dir = new File(args[2]);
            } else {
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                return true;
            }
            file_to_download = args[1];
            if (file_to_download.indexOf(58) == -1) {
                this.downloadFromServer(agent, out, file_to_download, storage_dir);
            } else {
                this.downloadFromURL(out, new URL(file_to_download), storage_dir);
            }
        }
        catch (Exception e) {
            out.println(MSG.getMsg("PromptCommand.download.error", new Object[]{file_to_download, ThrowableUtil.getAllMessages((Throwable)e)}));
        }
        return true;
    }

    private void downloadFromURL(PrintWriter out, URL url, File storage_dir) throws IOException {
        String file_to_download = url.getFile();
        InputStream in = url.openStream();
        this.downloadStream(out, storage_dir, file_to_download, in);
    }

    private void downloadFromServer(AgentMain agent, PrintWriter out, String file_to_download, File storage_dir) throws FileNotFoundException {
        ClientCommandSender sender = agent.getClientCommandSender();
        if (sender == null) {
            out.println(MSG.getMsg("PromptCommand.download.error-not-sending", new Object[]{file_to_download}));
        } else {
            ClientRemotePojoFactory factory = sender.getClientRemotePojoFactory();
            CoreServerService server = (CoreServerService)factory.getRemotePojo(CoreServerService.class);
            InputStream in = server.getFileContents(file_to_download);
            this.downloadStream(out, storage_dir, file_to_download, in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadStream(PrintWriter out, File storage_dir, String file_to_download, InputStream in) throws FileNotFoundException {
        FileOutputStream storage_file_stream = null;
        try {
            if (file_to_download == null || file_to_download.length() == 0) {
                file_to_download = "agent-download.txt";
            }
            File storage_file = new File(storage_dir, file_to_download);
            storage_file.getParentFile().mkdirs();
            storage_file_stream = new FileOutputStream(storage_file, false);
            out.println(MSG.getMsg("PromptCommand.download.in-progress", new Object[]{file_to_download}));
            StreamUtil.copy((InputStream)in, (OutputStream)storage_file_stream, (boolean)true);
            in = null;
            storage_file_stream = null;
            out.println(MSG.getMsg("PromptCommand.download.success", new Object[]{storage_file}));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
            if (storage_file_stream != null) {
                try {
                    storage_file_stream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.download.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.download.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.download.detailed-help", new Object[0]);
    }
}

