/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import mazz.i18n.Msg;
import org.rhq.core.domain.cloud.composite.FailoverListComposite;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class FailoverPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.failover", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        this.processArguments(agent, args);
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.failover.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.failover.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.failover.detailed-help", new Object[0]);
    }

    private void processArguments(AgentMain agent, String[] args) {
        int code;
        AgentPrintWriter out = agent.getOut();
        if (args.length <= 1) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return;
        }
        String sopts = "clrs:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("check", 0, null, 99), new LongOpt("list", 0, null, 108), new LongOpt("reset", 0, null, 114), new LongOpt("switch", 1, null, 115)};
        Getopt getopt = new Getopt(this.getPromptCommandString(), args, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 1: 
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    break;
                }
                case 99: {
                    out.println(MSG.getMsg("PromptCommand.failover.check-now", new Object[0]));
                    agent.performPrimaryServerSwitchoverCheck();
                    break;
                }
                case 108: {
                    this.showFailoverList(agent, out);
                    break;
                }
                case 114: {
                    agent.getServerFailoverList().resetIndex();
                    out.println(MSG.getMsg("PromptCommand.failover.reset-done", new Object[0]));
                    ((PrintWriter)out).println();
                    this.showFailoverList(agent, out);
                    break;
                }
                case 115: {
                    String server = getopt.getOptarg();
                    if (agent.switchToServer(server)) {
                        out.println(MSG.getMsg("PromptCommand.failover.immediate_switch-done", new Object[]{server}));
                        break;
                    }
                    out.println(MSG.getMsg("PromptCommand.failover.immediate_switch-failed", new Object[]{server}));
                    break;
                }
            }
        }
        if (getopt.getOptind() + 1 < args.length) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
        }
    }

    private void showFailoverList(AgentMain agent, PrintWriter out) {
        FailoverListComposite failoverList = agent.getServerFailoverList();
        if (failoverList != null && failoverList.size() > 0) {
            out.println(failoverList.writeAsText());
        } else {
            out.println("<>");
        }
    }
}

