/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Set;
import mazz.i18n.Msg;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryFile;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.util.InventoryPrinter;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.agent.promptcmd.PluginContainerPromptCommand;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;

public class InventoryPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.inventory", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        String[] realArgs = new String[args.length - 1];
        System.arraycopy(args, 1, realArgs, 0, args.length - 1);
        this.processCommand(realArgs, agent);
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.inventory.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.inventory.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.inventory.detailed-help", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand(String[] args, AgentMain agent) {
        int code;
        AgentPrintWriter out = agent.getOut();
        String inventoryBinaryFile = null;
        String exportFile = null;
        boolean dumpXml = false;
        boolean dumpTypesOnly = false;
        Integer id = null;
        boolean noRecurse = false;
        boolean sync = false;
        String sopts = "-se:i:ntx";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("export", 1, null, 101), new LongOpt("id", 1, null, 105), new LongOpt("norecurse", 0, null, 110), new LongOpt("sync", 0, null, 115), new LongOpt("types", 0, null, 116), new LongOpt("xml", 0, null, 120)};
        Getopt getopt = new Getopt(this.getPromptCommandString(), args, sopts, lopts);
        while (inventoryBinaryFile == null && (code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    return;
                }
                case 1: {
                    inventoryBinaryFile = getopt.getOptarg();
                    break;
                }
                case 115: {
                    sync = true;
                    break;
                }
                case 101: {
                    exportFile = getopt.getOptarg();
                    break;
                }
                case 116: {
                    dumpTypesOnly = true;
                    break;
                }
                case 110: {
                    noRecurse = true;
                    break;
                }
                case 105: {
                    String idString = getopt.getOptarg();
                    try {
                        id = Integer.valueOf(idString);
                        break;
                    }
                    catch (NumberFormatException e) {
                        out.println(MSG.getMsg("PromptCommand.inventory.bad-id", new Object[]{idString}));
                        return;
                    }
                }
                case 120: {
                    dumpXml = true;
                }
            }
        }
        if (getopt.getOptind() < args.length) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return;
        }
        if (sync) {
            this.syncInventory(agent, out);
            return;
        }
        if (inventoryBinaryFile != null && dumpTypesOnly) {
            out.println(MSG.getMsg("PromptCommand.inventory.dump-types-and-file-specified", new Object[0]));
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return;
        }
        if (inventoryBinaryFile != null && id != null) {
            out.println(MSG.getMsg("PromptCommand.inventory.id-and-file-specified", new Object[0]));
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return;
        }
        if (dumpTypesOnly && id != null) {
            out.println(MSG.getMsg("PromptCommand.inventory.id-and-dump-types-specified", new Object[0]));
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return;
        }
        PluginContainer pc = PluginContainer.getInstance();
        if (!agent.isStarted() || !pc.isStarted()) {
            out.println(MSG.getMsg("PromptCommand.inventory.must-be-started", new Object[0]));
            return;
        }
        PrintWriter exportWriter = out;
        if (exportFile != null) {
            try {
                FileOutputStream fos = new FileOutputStream(new File(exportFile));
                exportWriter = new PrintWriter(fos);
            }
            catch (Exception e) {
                out.println(MSG.getMsg("PromptCommand.inventory.bad-export-file", new Object[]{exportFile, e}));
                return;
            }
        }
        try {
            if (inventoryBinaryFile == null) {
                if (dumpTypesOnly) {
                    Set rootTypes = pc.getPluginManager().getMetadataManager().getRootTypes();
                    InventoryPrinter.outputAllResourceTypes((PrintWriter)exportWriter, (boolean)dumpXml, (Set)rootTypes);
                } else {
                    ResourceContainer rc = null;
                    if (id != null && (rc = pc.getInventoryManager().getResourceContainer(id.intValue())) == null) {
                        out.println(MSG.getMsg("PromptCommand.inventory.invalid-resource-id", new Object[]{id}));
                        return;
                    }
                    InventoryPrinter.outputInventory((PrintWriter)exportWriter, (!noRecurse ? 1 : 0) != 0, (boolean)dumpXml, (ResourceContainer)rc);
                }
            } else {
                try {
                    InventoryFile file = new InventoryFile(new File(inventoryBinaryFile));
                    file.loadInventory();
                    InventoryPrinter.outputInventory((PrintWriter)exportWriter, (!noRecurse ? 1 : 0) != 0, (boolean)dumpXml, (InventoryFile)file);
                }
                catch (PluginContainerException e) {
                    out.println(MSG.getMsg("PromptCommand.inventory.bad-inventory-file", new Object[]{inventoryBinaryFile, e}));
                }
            }
        }
        finally {
            if (exportFile != null) {
                exportWriter.close();
            }
        }
    }

    private void syncInventory(AgentMain agent, PrintWriter out) {
        boolean recyclePC = agent.isPluginContainerStarted();
        ClientCommandSender clientCommandSender = agent.getClientCommandSender();
        if (clientCommandSender == null || !clientCommandSender.isSending()) {
            out.println(MSG.getMsg("PromptCommand.inventory.error-not-sending", new Object[0]));
            return;
        }
        if (recyclePC) {
            this.executePCCommand(agent, "stop");
        }
        File dataDir = agent.getConfiguration().getPluginContainerConfiguration().getDataDirectory();
        File inventoryDataFile = new File(dataDir, "inventory.dat");
        inventoryDataFile.delete();
        if (!inventoryDataFile.exists()) {
            out.println(MSG.getMsg("PromptCommand.inventory.data-file-deleted", new Object[]{inventoryDataFile}));
        } else {
            out.println(MSG.getMsg("PromptCommand.inventory.data-file-deletion-failure", new Object[]{inventoryDataFile}));
        }
        if (recyclePC) {
            this.executePCCommand(agent, "start");
        }
    }

    private void executePCCommand(AgentMain agent, String startOrStop) {
        PluginContainerPromptCommand command = new PluginContainerPromptCommand();
        command.execute(agent, new String[]{command.getPromptCommandString(), startOrStop});
    }
}

