/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class ListDataPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.listdata", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        String[] realArgs = new String[args.length - 1];
        System.arraycopy(args, 1, realArgs, 0, args.length - 1);
        this.processArguments(agent, realArgs);
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.listdata.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.listdata.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.listdata.detailed-help", new Object[0]);
    }

    private void processArguments(AgentMain agent, String[] args) {
        int code;
        AgentPrintWriter out = agent.getOut();
        String sopts = "-dvr";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("verbose", 0, null, 118), new LongOpt("recurse", 0, null, 114), new LongOpt("delete", 0, null, 100)};
        Getopt getopt = new Getopt(this.getPromptCommandString(), args, sopts, lopts);
        boolean verbose = false;
        boolean recurse = false;
        boolean delete = false;
        String pathname = null;
        while (pathname == null && (code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    break;
                }
                case 1: {
                    pathname = getopt.getOptarg();
                    break;
                }
                case 118: {
                    verbose = true;
                    break;
                }
                case 114: {
                    recurse = true;
                    break;
                }
                case 100: {
                    delete = true;
                }
            }
        }
        if (getopt.getOptind() < args.length || pathname == null) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return;
        }
        if (pathname.indexOf("..") != -1) {
            out.println(MSG.getMsg("PromptCommand.listdata.dotdot-not-allowed", new Object[0]));
            return;
        }
        if (new File(pathname).isAbsolute()) {
            out.println(MSG.getMsg("PromptCommand.listdata.absolute-not-allowed", new Object[0]));
            return;
        }
        String dataDir = agent.getConfiguration().getDataDirectory().getAbsolutePath();
        if (verbose) {
            out.println(MSG.getMsg("PromptCommand.listdata.data_dir", new Object[]{dataDir}));
        }
        if ("bundles".equals(pathname)) {
            pathname = "tmp/bundle-versions";
        }
        this.list(out, dataDir, new File(dataDir, pathname), verbose, recurse, delete);
    }

    private void list(PrintWriter out, String dataDir, File file, boolean verbose, boolean recurse, boolean delete) {
        String relativePath = this.getRelativePath(dataDir, file);
        if (file.isFile()) {
            this.printFileInfo(out, dataDir, file, verbose);
        } else if (file.isDirectory()) {
            this.printDirInfo(out, dataDir, file, verbose);
            File[] dirFiles = file.listFiles();
            if (recurse) {
                for (File dirFile : dirFiles) {
                    this.list(out, dataDir, dirFile, verbose, recurse, delete);
                }
            }
        } else {
            out.println(MSG.getMsg("PromptCommand.listdata.file_not_found", new Object[]{relativePath}));
            return;
        }
        if (delete) {
            boolean ok = file.delete();
            if (ok) {
                out.println(MSG.getMsg("PromptCommand.listdata.deleted", new Object[]{relativePath}));
            } else {
                out.println(MSG.getMsg("PromptCommand.listdata.deleted_failed", new Object[]{relativePath}));
            }
        }
    }

    private void printFileInfo(PrintWriter out, String dataDir, File file, boolean verbose) {
        String name = this.getRelativePath(dataDir, file);
        if (verbose) {
            long filesize = file.length();
            Date lastModified = new Date(file.lastModified());
            out.println(MSG.getMsg("PromptCommand.listdata.file_info_verbose", new Object[]{name, lastModified, filesize}));
        } else {
            out.println(MSG.getMsg("PromptCommand.listdata.file_info", new Object[]{name}));
        }
    }

    private void printDirInfo(PrintWriter out, String dataDir, File dir, boolean verbose) {
        String name = this.getRelativePath(dataDir, dir);
        if (verbose) {
            int filecount = dir.listFiles().length;
            Date lastModified = new Date(dir.lastModified());
            out.println(MSG.getMsg("PromptCommand.listdata.dir_info_verbose", new Object[]{name, lastModified, filecount}));
        } else {
            out.println(MSG.getMsg("PromptCommand.listdata.dir_info", new Object[]{name}));
        }
    }

    private String getRelativePath(String dataDir, File file) {
        try {
            return file.getAbsolutePath().substring(dataDir.length());
        }
        catch (Exception e) {
            return file.getPath();
        }
    }
}

