/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.AgentRestartCounter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class StartPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.start", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        if (args.length > 1) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return true;
        }
        if (!agent.isStarted()) {
            try {
                out.println(MSG.getMsg("PromptCommand.start.starting", new Object[0]));
                agent.start();
                out.println(MSG.getMsg("PromptCommand.start.started", new Object[0]));
                agent.getAgentRestartCounter().restartedAgent(AgentRestartCounter.AgentRestartReason.PROMPT_COMMAND);
            }
            catch (Exception e) {
                out.println(MSG.getMsg("PromptCommand.start.failure", new Object[0]));
                e.printStackTrace(out);
            }
        } else {
            out.println(MSG.getMsg("PromptCommand.start.already-started", new Object[0]));
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return this.getPromptCommandString();
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.start.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.start.detailed-help", new Object[0]);
    }
}

