/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import mazz.i18n.Msg;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.Version;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class VersionPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.version", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        int code;
        AgentPrintWriter out = agent.getOut();
        String versionString = Version.getVersionPropertiesAsString();
        if (args.length <= 1) {
            out.println(versionString);
            return true;
        }
        String sopts = "hs::e::";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("sysprops", 2, null, 115), new LongOpt("env", 2, null, 101), new LongOpt("host", 0, null, 104)};
        out.println(versionString);
        Getopt getopt = new Getopt(this.getPromptCommandString(), args, sopts, lopts);
        block8: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 1: 
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    break;
                }
                case 104: {
                    ((PrintWriter)out).println();
                    out.println(MSG.getMsg("PromptCommand.version.host-label", new Object[0]));
                    try {
                        InetAddress localhost = InetAddress.getLocalHost();
                        String name = localhost.getCanonicalHostName();
                        String ip = localhost.getHostAddress();
                        out.println(name + '(' + ip + ')');
                    }
                    catch (Exception e) {
                        out.println(ThrowableUtil.getAllMessages((Throwable)e));
                    }
                    break;
                }
                case 115: {
                    ((PrintWriter)out).println();
                    out.println(MSG.getMsg("PromptCommand.version.sysprops-label", new Object[0]));
                    String opt = getopt.getOptarg();
                    Properties sysprops = System.getProperties();
                    for (Map.Entry<Object, Object> entry : sysprops.entrySet()) {
                        if (opt != null && !entry.getKey().toString().startsWith(opt)) continue;
                        out.println(entry.getKey() + "=" + entry.getValue());
                    }
                    continue block8;
                }
                case 101: {
                    ((PrintWriter)out).println();
                    out.println(MSG.getMsg("PromptCommand.version.env-label", new Object[0]));
                    String opt = getopt.getOptarg();
                    Map<String, String> envvars = System.getenv();
                    if (envvars == null) {
                        envvars = new HashMap<String, String>();
                    }
                    for (Map.Entry<Object, Object> entry : envvars.entrySet()) {
                        if (opt != null && !((String)entry.getKey()).startsWith(opt)) continue;
                        out.println((String)entry.getKey() + "=" + (String)entry.getValue());
                    }
                    continue block8;
                }
            }
        }
        if (getopt.getOptind() + 1 < args.length) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.version.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.version.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return this.getHelp();
    }
}

