/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import mazz.i18n.Logger;
import org.rhq.core.util.file.FileUtil;
import org.rhq.enterprise.agent.ExternalizableStrategyCommandPreprocessor;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.communications.util.prefs.PreferencesUpgrade;
import org.rhq.enterprise.communications.util.prefs.PreferencesUpgradeStep;

public class AgentConfigurationUpgrade
extends PreferencesUpgrade {
    private static final Logger LOG = AgentI18NFactory.getLogger(AgentConfigurationUpgrade.class);

    public static void upgradeToLatest(Preferences preferences) {
        new AgentConfigurationUpgrade().upgrade(preferences, 7);
    }

    public AgentConfigurationUpgrade() {
        super(AgentConfigurationUpgrade.getSteps());
    }

    public String getConfigurationSchemaVersionPreference() {
        return "rhq.agent.configuration-schema-version";
    }

    private static List<PreferencesUpgradeStep> getSteps() {
        ArrayList<PreferencesUpgradeStep> list = new ArrayList<PreferencesUpgradeStep>();
        list.add(new Step1to2());
        list.add(new Step2to3());
        list.add(new Step3to4());
        list.add(new Step4to5());
        list.add(new Step5to6());
        list.add(new Step6to7());
        return list;
    }

    static class Step6to7
    extends PreferencesUpgradeStep {
        Step6to7() {
        }

        public int getSupportedConfigurationSchemaVersion() {
            return 7;
        }

        public void upgrade(Preferences preferences) {
            String[][] prefNamesFileNames;
            File confDir = new File("conf");
            if (!confDir.exists()) {
                return;
            }
            String dataDir = preferences.get("rhq.agent.data-directory", "data");
            for (String[] prefNameFileName : prefNamesFileNames = new String[][]{{"rhq.communications.connector.security.keystore.file", "keystore.dat"}, {"rhq.communications.connector.security.truststore.file", "truststore.dat"}, {"rhq.agent.client.security.keystore.file", "keystore.dat"}, {"rhq.agent.client.security.truststore.file", "truststore.dat"}}) {
                String value = preferences.get(prefNameFileName[0], null);
                if (value != null) continue;
                File newFile = new File(confDir, prefNameFileName[1]);
                value = newFile.getAbsolutePath();
                preferences.put(prefNameFileName[0], value);
                File oldFile = new File(dataDir, prefNameFileName[1]);
                if (oldFile.exists()) {
                    try {
                        FileUtil.copyFile((File)oldFile, (File)newFile);
                        oldFile.delete();
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e, "AgentConfiguration.cert-file-copy-error", new Object[]{oldFile, newFile});
                    }
                }
                LOG.debug("AgentConfiguration.cert-file-location", new Object[]{prefNameFileName[0], value});
            }
        }
    }

    static class Step5to6
    extends PreferencesUpgradeStep {
        Step5to6() {
        }

        public int getSupportedConfigurationSchemaVersion() {
            return 6;
        }

        public void upgrade(Preferences preferences) {
            preferences.put("rhq.agent.server.alias", "rhqserver");
        }
    }

    static class Step4to5
    extends PreferencesUpgradeStep {
        Step4to5() {
        }

        public int getSupportedConfigurationSchemaVersion() {
            return 5;
        }

        public void upgrade(Preferences preferences) {
            String newPreprocessor = ExternalizableStrategyCommandPreprocessor.class.getName();
            String val = preferences.get("rhq.agent.client.command-preprocessors", null);
            if (val != null && !val.contains(newPreprocessor)) {
                val = val + ':' + newPreprocessor;
                preferences.put("rhq.agent.client.command-preprocessors", val);
            }
        }
    }

    static class Step3to4
    extends PreferencesUpgradeStep {
        Step3to4() {
        }

        public int getSupportedConfigurationSchemaVersion() {
            return 4;
        }

        public void upgrade(Preferences preferences) {
            long val = preferences.getLong("rhq.agent.plugins.availability-scan.period-secs", Long.MAX_VALUE);
            if (val < 30L) {
                preferences.putLong("rhq.agent.plugins.availability-scan.period-secs", 30L);
            }
        }
    }

    static class Step2to3
    extends PreferencesUpgradeStep {
        Step2to3() {
        }

        public int getSupportedConfigurationSchemaVersion() {
            return 3;
        }

        public void upgrade(Preferences preferences) {
            preferences.putLong("rhq.agent.vm-health-check.interval-msecs", 5000L);
            preferences.putFloat("rhq.agent.vm-health-check.low-heap-mem-threshold", 0.9f);
            preferences.putFloat("rhq.agent.vm-health-check.low-nonheap-mem-threshold", 0.9f);
            preferences.putBoolean("rhq.agent.agent-update.enabled", true);
        }
    }

    static class Step1to2
    extends PreferencesUpgradeStep {
        Step1to2() {
        }

        public int getSupportedConfigurationSchemaVersion() {
            return 2;
        }

        public void upgrade(Preferences preferences) {
            preferences.putLong("rhq.agent.primary-server-switchover-check-interval-msecs", 3600000L);
        }
    }
}

