/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import mazz.i18n.Logger;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentUpdateInformation;
import org.rhq.enterprise.agent.AgentUpdateVersion;
import org.rhq.enterprise.agent.SecureConnector;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;

public class AgentUpdateDownload {
    private static final Logger LOG = AgentI18NFactory.getLogger(AgentUpdateDownload.class);
    private final AgentMain agent;
    private final AgentUpdateVersion agentUpdateVersion;
    private File downloadedFile;

    public AgentUpdateDownload(AgentMain agent) {
        this.agent = agent;
        this.agentUpdateVersion = new AgentUpdateVersion(agent);
        this.downloadedFile = null;
    }

    public AgentUpdateVersion getAgentUpdateVersion() {
        return this.agentUpdateVersion;
    }

    public URL getDownloadUrl() throws Exception {
        return new URL(this.agent.getConfiguration().getAgentUpdateDownloadUrl());
    }

    public File getAgentUpdateBinaryFile() {
        return this.downloadedFile;
    }

    public File getLocalDownloadDirectory() {
        String agentHome = this.agent.getAgentHomeDirectory();
        File dir = null;
        if (agentHome != null && agentHome.length() > 0) {
            dir = new File(agentHome).getParentFile();
        }
        if (dir == null) {
            dir = new File(System.getProperty("java.io.tmpdir"));
        }
        return dir;
    }

    public void validate() throws Exception {
        File fileToValidate = this.downloadedFile;
        if (fileToValidate == null || !fileToValidate.exists()) {
            throw new IllegalStateException(this.agent.getI18NMsg().getMsg("AgentUpdateDownload.md5.missing-file", new Object[]{fileToValidate}));
        }
        AgentUpdateInformation info = this.agentUpdateVersion.getAgentUpdateInformation();
        String md5 = info.getUpdateMd5();
        if (!this.validateFile(this.downloadedFile, md5)) {
            File invalidFile = new File(fileToValidate.getParentFile(), fileToValidate.getName() + ".invalid");
            invalidFile.delete();
            fileToValidate.renameTo(invalidFile);
            throw new IllegalStateException(this.agent.getI18NMsg().getMsg("AgentUpdateDownload.md5.invalid", new Object[]{fileToValidate}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws Exception {
        if (!this.agent.getConfiguration().isAgentUpdateEnabled()) {
            throw new Exception(this.agent.getI18NMsg().getMsg("AgentUpdateDownload.update-download-disabled-by-agent", new Object[0]));
        }
        AgentUpdateInformation info = this.agentUpdateVersion.getAgentUpdateInformation();
        URL url = null;
        boolean keep_going = true;
        File binaryFile = null;
        while (keep_going) {
            HttpURLConnection conn = null;
            InputStream inStream = null;
            try {
                File dir;
                url = this.getDownloadUrl();
                LOG.info("AgentUpdateDownload.update-download-retrieval", new Object[]{info, url});
                conn = url.getProtocol().equals("https") ? this.openSecureConnection(url) : (HttpURLConnection)url.openConnection();
                inStream = conn.getInputStream();
                String fileName = conn.getHeaderField("Content-Disposition");
                if (fileName != null) {
                    int filenameIndex = fileName.indexOf("filename=");
                    if (filenameIndex > -1 && filenameIndex + "filename=".length() < fileName.length()) {
                        fileName = fileName.substring(filenameIndex + "filename=".length()).trim();
                    } else {
                        LOG.warn("AgentUpdateDownload.update-download-bad-name", new Object[]{fileName});
                        fileName = null;
                    }
                }
                if (fileName == null || fileName.length() == 0) {
                    fileName = "rhq-enterprise-agent-" + info.getUpdateVersion() + ".jar";
                    LOG.info("AgentUpdateDownload.update-download-no-name", new Object[]{fileName});
                }
                if (this.validateFile(binaryFile = new File(dir = this.getLocalDownloadDirectory(), fileName), info.getUpdateMd5())) {
                    LOG.debug("AgentUpdateDownload.update-download-already-have-it", new Object[]{binaryFile});
                    keep_going = false;
                    break;
                }
                binaryFile.delete();
                FileOutputStream fos = new FileOutputStream(binaryFile);
                StreamUtil.copy((InputStream)inStream, (OutputStream)fos, (boolean)true);
                inStream = null;
                keep_going = false;
            }
            catch (Exception e) {
                if (conn != null) {
                    int responseCode = 0;
                    try {
                        responseCode = conn.getResponseCode();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    if (responseCode == 503) {
                        LOG.info("AgentUpdateDownload.update-download-unavailable", new Object[]{info, url});
                        Thread.sleep(this.getRetryAfter(conn));
                        keep_going = true;
                        continue;
                    }
                    if (responseCode == 403) {
                        Exception e1 = new Exception(this.agent.getI18NMsg().getMsg("AgentUpdateDownload.update-download-disabled-by-server", new Object[]{url}), e);
                        LOG.warn("AgentUpdateDownload.update-download-failure", new Object[]{url, ThrowableUtil.getAllMessages((Throwable)e1)});
                        throw e1;
                    }
                    LOG.warn("AgentUpdateDownload.update-download-failure", new Object[]{url, ThrowableUtil.getAllMessages((Throwable)e)});
                    throw e;
                }
                LOG.warn("AgentUpdateDownload.update-download-failure", new Object[]{url, ThrowableUtil.getAllMessages((Throwable)e)});
                throw e;
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception e) {}
                }
                if (conn == null) continue;
                try {
                    conn.disconnect();
                }
                catch (Exception e) {}
            }
        }
        LOG.info("AgentUpdateDownload.update-download-done", new Object[]{info, url, binaryFile});
        this.downloadedFile = binaryFile;
    }

    private long getRetryAfter(HttpURLConnection conn) {
        try {
            int retryAfter = conn.getHeaderFieldInt("Retry-After", 30);
            return 1000L * (long)retryAfter;
        }
        catch (Exception e) {
            return 30000L;
        }
    }

    private boolean validateFile(File file, String md5) {
        try {
            String filemd5 = MessageDigestGenerator.getDigestString((File)file);
            return filemd5 != null && filemd5.equals(md5);
        }
        catch (Exception e) {
            return false;
        }
    }

    private HttpsURLConnection openSecureConnection(URL url) throws Exception {
        SecureConnector secureConnector;
        AgentConfiguration config = this.agent.getConfiguration();
        String secureSocketProtocol = config.getClientSenderSecuritySocketProtocol();
        if (config.isClientSenderSecurityServerAuthMode()) {
            File file = new File(config.getClientSenderSecurityTruststoreFile());
            if (!file.isAbsolute()) {
                file = new File(this.agent.getAgentHomeDirectory(), file.getPath());
            }
            String password = config.getClientSenderSecurityTruststorePassword();
            String type = config.getClientSenderSecurityTruststoreType();
            String algorithm = config.getClientSenderSecurityTruststoreAlgorithm();
            secureConnector = new SecureConnector(secureSocketProtocol, file, password, type, algorithm);
        } else {
            secureConnector = new SecureConnector(secureSocketProtocol);
        }
        return secureConnector.openSecureConnection(url);
    }
}

