/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.util.Arrays;
import java.util.List;
import mazz.i18n.Msg;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class NativePromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.native", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        if (args.length <= 1) {
            out.println(MSG.getMsg(SystemInfoFactory.isNativeSystemInfoDisabled() ? "PromptCommand.native.is-disabled" : "PromptCommand.native.is-not-disabled", new Object[0]));
            if (!SystemInfoFactory.isNativeSystemInfoDisabled()) {
                out.println(MSG.getMsg(SystemInfoFactory.isNativeSystemInfoAvailable() ? "PromptCommand.native.is-available" : "PromptCommand.native.is-not-available", new Object[0]));
                out.println(MSG.getMsg(SystemInfoFactory.isNativeSystemInfoInitialized() ? "PromptCommand.native.is-initialized" : "PromptCommand.native.is-not-initialized", new Object[0]));
            }
            return true;
        }
        this.processArguments(agent, args);
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.native.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.native.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.native.detailed-help", new Object[0]);
    }

    private void processArguments(AgentMain agent, String[] args) {
        int code;
        AgentPrintWriter out = agent.getOut();
        String sopts = "deop::sv";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("disable", 0, null, 100), new LongOpt("enable", 0, null, 101), new LongOpt("os", 0, null, 111), new LongOpt("ps", 2, null, 112), new LongOpt("shutdown", 0, null, 115), new LongOpt("version", 0, null, 118)};
        Getopt getopt = new Getopt("native", args, sopts, lopts);
        block11: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 1: 
                case 58: 
                case 63: {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    break;
                }
                case 100: {
                    SystemInfoFactory.disableNativeSystemInfo();
                    out.println(MSG.getMsg("PromptCommand.native.disable-done", new Object[0]));
                    break;
                }
                case 101: {
                    SystemInfoFactory.enableNativeSystemInfo();
                    out.println(MSG.getMsg("PromptCommand.native.enable-done", new Object[0]));
                    break;
                }
                case 111: {
                    SystemInfo sysInfo = SystemInfoFactory.createSystemInfo();
                    out.println(MSG.getMsg("PromptCommand.native.os-output", new Object[]{sysInfo.getOperatingSystemName(), sysInfo.getOperatingSystemVersion(), sysInfo.getHostname()}));
                    break;
                }
                case 112: {
                    SystemInfo sysInfo = SystemInfoFactory.createSystemInfo();
                    String verboseOpt = getopt.getOptarg();
                    boolean verbose = verboseOpt != null && verboseOpt.equals(MSG.getMsg("PromptCommand.native.verbose", new Object[0]));
                    try {
                        List processes = sysInfo.getAllProcesses();
                        if (verbose) {
                            out.println(MSG.getMsg("PromptCommand.native.ps-output-verbose-header", new Object[0]));
                        } else {
                            out.println(MSG.getMsg("PromptCommand.native.ps-output-short-header", new Object[0]));
                        }
                        for (ProcessInfo p : processes) {
                            if (verbose) {
                                out.println(MSG.getMsg("PromptCommand.native.ps-output-verbose", new Object[]{p.getPid(), p.getParentPid(), p.getBaseName(), Arrays.toString(p.getCommandLine())}));
                                continue;
                            }
                            out.println(MSG.getMsg("PromptCommand.native.ps-output-short", new Object[]{p.getPid(), p.getName()}));
                        }
                        continue block11;
                    }
                    catch (Exception e) {
                        out.println(MSG.getMsg("PromptCommand.native.not-supported", new Object[0]));
                        break;
                    }
                }
                case 115: {
                    if (!agent.isStarted()) {
                        SystemInfoFactory.shutdown();
                        SystemInfoFactory.disableNativeSystemInfo();
                        out.println(MSG.getMsg("PromptCommand.native.shutdown-done", new Object[0]));
                        break;
                    }
                    out.println(MSG.getMsg("PromptCommand.native.shutdown-done-failed-agent-started", new Object[0]));
                    break;
                }
                case 118: {
                    out.println(SystemInfoFactory.getNativeSystemInfoVersion());
                }
            }
        }
        if (getopt.getOptind() + 1 < args.length) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
        }
    }
}

