/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.util.ArrayList;
import java.util.List;
import mazz.i18n.Logger;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.PollingListener;
import org.rhq.enterprise.communications.command.impl.identify.IdentifyCommand;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.CommUtils;

class ServerPollingThread
extends Thread {
    private static final Logger LOG = CommI18NFactory.getLogger(ServerPollingThread.class);
    private final ClientCommandSender m_clientSender;
    private final long m_interval;
    private boolean m_stop;
    private boolean m_stopped;
    private boolean m_warnedAboutConnectionFailure;
    private final List<PollingListener> m_pollingListeners = new ArrayList<PollingListener>();

    public ServerPollingThread(ClientCommandSender client, long polling_interval) {
        super("RHQ Server Polling Thread");
        this.setDaemon(true);
        this.m_clientSender = client;
        this.m_interval = polling_interval;
        this.m_stop = false;
        this.m_stopped = true;
        this.m_warnedAboutConnectionFailure = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_stopped = false;
        LOG.debug("ServerPollingThread.started", new Object[]{this.m_interval});
        while (!this.m_stop) {
            try {
                block17: {
                    try {
                        IdentifyCommand id_cmd = new IdentifyCommand();
                        this.m_clientSender.preprocessCommand(id_cmd);
                        CommandResponse response = this.m_clientSender.send(id_cmd);
                        List<PollingListener> list = this.m_pollingListeners;
                        synchronized (list) {
                            for (PollingListener listener : this.m_pollingListeners) {
                                try {
                                    listener.pollResponse(response);
                                }
                                catch (Throwable t) {}
                            }
                        }
                        if (CommUtils.isExceptionFailoverable(response.getException())) {
                            throw response.getException();
                        }
                        if (this.m_clientSender.startSending()) {
                            LOG.info("ServerPollingThread.server-online", new Object[0]);
                            this.m_warnedAboutConnectionFailure = false;
                        }
                    }
                    catch (Throwable e) {
                        if (!this.m_warnedAboutConnectionFailure) {
                            this.m_warnedAboutConnectionFailure = true;
                            LOG.debug("ServerPollingThread.server-poll-failure", new Object[]{ThrowableUtil.getAllMessages((Throwable)e)});
                        }
                        if (!this.m_clientSender.stopSending(false)) break block17;
                        LOG.warn("ServerPollingThread.server-offline", new Object[0]);
                    }
                }
                ServerPollingThread e = this;
                synchronized (e) {
                    this.wait(this.m_interval);
                }
            }
            catch (InterruptedException e) {
                this.m_stop = true;
            }
        }
        LOG.debug("ServerPollingThread.stopped", new Object[0]);
        this.m_stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPolling() {
        this.m_stop = true;
        Object object = this;
        synchronized (object) {
            while (!this.m_stopped) {
                try {
                    this.notifyAll();
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = this.m_pollingListeners;
        synchronized (object) {
            this.m_pollingListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPollingListener(PollingListener listener) {
        List<PollingListener> list = this.m_pollingListeners;
        synchronized (list) {
            if (!this.m_pollingListeners.contains(listener)) {
                this.m_pollingListeners.add(listener);
                LOG.debug("ServerPollingThread.added-polling-listener", new Object[]{listener});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePollingListener(PollingListener listener) {
        List<PollingListener> list = this.m_pollingListeners;
        synchronized (list) {
            this.m_pollingListeners.remove(listener);
            LOG.debug("ServerPollingThread.removed-polling-listener", new Object[]{listener});
        }
    }
}

