/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.util.prefs;

import java.io.PrintWriter;
import java.util.prefs.Preferences;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.prefs.SetupValidityChecker;

public class IntegerSetupValidityChecker
implements SetupValidityChecker {
    private Integer m_min;
    private Integer m_max;

    public IntegerSetupValidityChecker(Integer min_value_allowed, Integer max_value_allowed) {
        this.m_min = min_value_allowed;
        this.m_max = max_value_allowed;
    }

    public boolean checkValidity(String pref_name, String value_to_check, Preferences preferences, PrintWriter out) {
        try {
            int new_int = Integer.parseInt(value_to_check);
            if (this.m_min != null && new_int < this.m_min) {
                out.println(CommI18NFactory.getMsg().getMsg("Setup.number-checker.too-low", new Object[]{value_to_check, this.m_min}));
                return false;
            }
            if (this.m_max != null && new_int > this.m_max) {
                out.println(CommI18NFactory.getMsg().getMsg("Setup.number-checker.too-high", new Object[]{value_to_check, this.m_max}));
                return false;
            }
        }
        catch (NumberFormatException e) {
            out.println(CommI18NFactory.getMsg().getMsg("Setup.integer-checker.not-an-integer", new Object[]{value_to_check}));
            return false;
        }
        return true;
    }
}

