/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.util.Map;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.CommandClient;
import org.rhq.enterprise.communications.command.client.RemoteCommunicator;

public abstract class AbstractCommandClient
implements CommandClient {
    private RemoteCommunicator m_remoteCommunicator;

    public AbstractCommandClient() {
        this(null);
    }

    public AbstractCommandClient(RemoteCommunicator communicator) {
        this.m_remoteCommunicator = communicator;
    }

    @Override
    public void setRemoteCommunicator(RemoteCommunicator communicator) {
        if (communicator == null) {
            throw new IllegalArgumentException("communicator=null");
        }
        if (this.m_remoteCommunicator != null) {
            this.m_remoteCommunicator.disconnect();
            this.m_remoteCommunicator = null;
        }
        this.m_remoteCommunicator = communicator;
    }

    @Override
    public RemoteCommunicator getRemoteCommunicator() {
        return this.m_remoteCommunicator;
    }

    @Override
    public void connectRemoteCommunicator() throws Exception {
        if (this.m_remoteCommunicator != null && !this.m_remoteCommunicator.isConnected()) {
            this.m_remoteCommunicator.connect();
        }
    }

    @Override
    public void disconnectRemoteCommunicator() {
        if (this.m_remoteCommunicator != null) {
            this.m_remoteCommunicator.disconnect();
        }
    }

    @Override
    public CommandResponse invoke(Map<String, Object> params) throws Throwable {
        Command command = this.createNewCommand(params);
        command.setCommandInResponse(true);
        return this.invoke(command);
    }

    @Override
    public CommandResponse invoke(Command command) throws Throwable {
        command.checkParameterValidity(true);
        CommandResponse retResponse = this.getRemoteCommunicator().send(command);
        return retResponse;
    }
}

