/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.vfs.helpers;

import java.util.StringTokenizer;

public class PathTokenizer {
    private PathTokenizer() {
    }

    public static String[] getTokens(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        int count = tokenizer.countTokens();
        if (count == 0) {
            return null;
        }
        String[] tokens = new String[count];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("")) {
                throw new IllegalArgumentException("A path element is empty: " + path);
            }
            if (token.equals(".") || token.equals("..")) {
                throw new IllegalArgumentException("Reverse paths are not allowed (containing a . or ..), use getParent(): " + path);
            }
            tokens[i++] = token;
        }
        return tokens;
    }

    public static String getRemainingPath(String[] tokens, int i) {
        if (tokens == null) {
            throw new IllegalArgumentException("Null tokens");
        }
        if (i < 0 || i >= tokens.length) {
            throw new IllegalArgumentException("i is not in the range of tokens: 0" + (tokens.length - 1));
        }
        if (i == tokens.length - 1) {
            return tokens[tokens.length - 1];
        }
        StringBuilder buffer = new StringBuilder();
        while (i < tokens.length - 1) {
            buffer.append(tokens[i]);
            buffer.append("/");
            ++i;
        }
        buffer.append(tokens[tokens.length - 1]);
        return buffer.toString();
    }
}

