/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.Permission;

public class FileURLConnection
extends URLConnection {
    static boolean decodeFilePaths = true;
    protected File file;

    public FileURLConnection(URL url) throws MalformedURLException, IOException {
        super(url);
        String path = url.getPath();
        if (decodeFilePaths) {
            path = URLDecoder.decode(path, "UTF-8");
        }
        this.file = new File(path.replace('/', File.separatorChar).replace('|', ':'));
        this.doOutput = false;
    }

    public File getFile() {
        return this.file;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getPath());
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        SecurityManager sm;
        if (!this.connected) {
            this.connect();
        }
        if ((sm = System.getSecurityManager()) != null) {
            FilePermission p = new FilePermission(this.file.getPath(), "write");
            sm.checkPermission(p);
        }
        return new FileOutputStream(this.file);
    }

    public String getHeaderField(String name) {
        String headerField = null;
        if (name.equalsIgnoreCase("last-modified")) {
            headerField = String.valueOf(this.getLastModified());
        } else if (name.equalsIgnoreCase("content-length")) {
            headerField = String.valueOf(this.file.length());
        } else if (name.equalsIgnoreCase("content-type")) {
            headerField = FileURLConnection.getFileNameMap().getContentTypeFor(this.file.getName());
            if (headerField == null) {
                try {
                    InputStream is = this.getInputStream();
                    BufferedInputStream bis = new BufferedInputStream(is);
                    headerField = URLConnection.guessContentTypeFromStream(bis);
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            headerField = name.equalsIgnoreCase("date") ? String.valueOf(this.file.lastModified()) : super.getHeaderField(name);
        }
        return headerField;
    }

    public Permission getPermission() throws IOException {
        return new FilePermission(this.file.getPath(), "read");
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    static {
        String flag = System.getProperty("org.jboss.net.protocol.file.decodeFilePaths");
        if (flag != null) {
            decodeFilePaths = Boolean.valueOf(flag);
        }
    }
}

