/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.filters;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;

public class SemaphoreValve
extends ValveBase
implements Lifecycle {
    private static final String info = "org.jboss.web.tomcat.filters.SemaphoreValve/1.0";
    protected Sync semaphore = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private boolean started = false;
    protected int concurrency = 10;

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("Semaphore valve already started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.semaphore = new FIFOSemaphore((long)this.concurrency);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("Semaphore valve not started");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.semaphore = null;
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean shouldRelease = false;
        try {
            this.semaphore.acquire();
            shouldRelease = true;
            this.getNext().invoke(request, response);
        }
        catch (InterruptedException e) {
            this.container.getLogger().error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (shouldRelease) {
                this.semaphore.release();
            }
        }
    }
}

