/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.configuration.ConfigManagementSupport;
import org.rhq.core.pc.configuration.ConfigurationUpdateException;
import org.rhq.core.pluginapi.configuration.ResourceConfigurationFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredConfigManagement
extends ConfigManagementSupport {
    private final Log log = LogFactory.getLog(StructuredConfigManagement.class);

    @Override
    public Configuration executeLoad(int resourceId) throws PluginContainerException {
        ResourceConfigurationFacet facet = this.loadResouceConfiguratonFacet(resourceId);
        Configuration configuration = facet.loadStructuredConfiguration();
        if (configuration == null) {
            return null;
        }
        ResourceType resourceType = this.componentService.getResourceType(resourceId);
        if (configuration.getNotes() == null) {
            configuration.setNotes("Resource config for " + resourceType.getName() + " Resource w/ id " + resourceId);
        }
        this.configUtilityService.normalizeConfiguration(configuration, resourceType.getResourceConfigurationDefinition());
        List<String> errorMsgs = this.configUtilityService.validateConfiguration(configuration, resourceType.getResourceConfigurationDefinition());
        this.logErrorMsgs(errorMsgs, resourceType);
        return configuration;
    }

    private void logErrorMsgs(List<String> errorMsgs, ResourceType resourceType) {
        for (String errorMessage : errorMsgs) {
            this.log.warn((Object)("Plugin Error: Invalid " + resourceType.getName() + " Resource configuration returned by " + resourceType.getPlugin() + " plugin - " + errorMessage));
        }
    }

    @Override
    public void executeUpdate(int resourceId, Configuration configuration) throws PluginContainerException {
        try {
            ResourceConfigurationFacet facet = this.loadResourceConfigFacetWithWriteLock(resourceId);
            facet.validateStructuredConfiguration(configuration);
            facet.persistStructuredConfiguration(configuration);
        }
        catch (Throwable t) {
            throw new ConfigurationUpdateException(t.getMessage());
        }
    }
}

