/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionMimeDetector
extends MimeDetector {
    private static Log log = LogFactory.getLog((Class)ExtensionMimeDetector.class);
    private static Map extMimeTypes;

    public String getDescription() {
        return "Get the mime types of file extensions";
    }

    public Collection getMimeTypesFile(File file) throws MimeException {
        HashSet<MimeType> mimeTypes = new HashSet<MimeType>();
        String fileExtension = MimeUtil.getExtension(file.getName());
        while (fileExtension.length() != 0) {
            String types = null;
            types = (String)extMimeTypes.get(fileExtension);
            if (types != null) {
                String[] mimeTypeArray = types.split(",");
                for (int i = 0; i < mimeTypeArray.length; ++i) {
                    mimeTypes.add(new MimeType(mimeTypeArray[i]));
                }
                return mimeTypes;
            }
            if (mimeTypes.isEmpty() && (types = (String)extMimeTypes.get(fileExtension.toLowerCase())) != null) {
                String[] mimeTypeArray = types.split(",");
                for (int i = 0; i < mimeTypeArray.length; ++i) {
                    mimeTypes.add(new MimeType(mimeTypeArray[i]));
                }
                return mimeTypes;
            }
            fileExtension = MimeUtil.getExtension(fileExtension);
        }
        return mimeTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMimeTypes() {
        extMimeTypes = new Properties();
        try {
            Properties props;
            FileInputStream is;
            ((Properties)extMimeTypes).load(MimeUtil.class.getClassLoader().getResourceAsStream("eu/medsea/mimeutil/mime-types.properties"));
            try {
                File f = new File(System.getProperty("user.home") + File.separator + ".mime-types.properties");
                if (f.exists() && (is = new FileInputStream(f)) != null) {
                    log.debug((Object)"Found a custom .mime-types.properties file in the users home directory.");
                    props = new Properties();
                    props.load(is);
                    if (props.size() > 0) {
                        extMimeTypes.putAll(props);
                    }
                    log.debug((Object)"Successfully parsed .mime-types.properties from users home directory.");
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to parse .magic.mime file from users home directory. File will be ignored.", (Throwable)e);
            }
            try {
                InputStream is2 = MimeUtil.class.getClassLoader().getResourceAsStream("mime-types.properties");
                if (is2 != null) {
                    log.debug((Object)"Found a custom mime-types.properties file on the classpath.");
                    Properties props2 = new Properties();
                    props2.load(is2);
                    if (props2.size() > 0) {
                        extMimeTypes.putAll(props2);
                    }
                    log.debug((Object)"Successfully loaded custome mime-type.properties file from classpath.");
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to load the mime-types.properties file located on the classpath. File will be ignored.");
            }
            try {
                String fname = System.getProperty("mime-mappings");
                if (fname != null && fname.length() != 0 && (is = new FileInputStream(fname)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found a custom mime-mappings property defined by the property -Dmime-mappings [" + System.getProperty("mime-mappings") + "]."));
                    }
                    props = new Properties();
                    props.load(is);
                    if (props.size() > 0) {
                        extMimeTypes.putAll(props);
                    }
                    log.debug((Object)("Successfully loaded the mime mappings file from property -Dmime-mappings [" + System.getProperty("mime-mappings") + "]."));
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to load the mime-mappings file defined by the property -Dmime-mappings [" + System.getProperty("mime-mappings") + "]."));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading internal mime-types.properties", (Throwable)e);
        }
        finally {
            Iterator it = extMimeTypes.values().iterator();
            while (it.hasNext()) {
                String[] types = ((String)it.next()).split(",");
                for (int i = 0; i < types.length; ++i) {
                    MimeUtil.addKnownMimeType(types[i]);
                }
            }
        }
    }

    public Collection getMimeTypesInputStream(InputStream in) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This MimeDetector does not support detection from streams.");
    }

    public Collection getMimeTypesByteArray(byte[] data) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This MimeDetector does not support detection from byte arrays.");
    }

    static {
        ExtensionMimeDetector.initMimeTypes();
        MimeUtil.addMimeDetector(new ExtensionMimeDetector());
    }
}

