/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.plugins.jbossas.util.JBossMessagingConfigurationEditor;

public class AbstractMessagingConfigurationEditor {
    protected static final Log LOG = LogFactory.getLog(JBossMessagingConfigurationEditor.class);
    private static final String JNDI_NAME = "JNDIName";
    protected static final String DEPENDS = "depends";
    protected String type;
    protected String code;
    protected String rootElementString = "server";
    protected Element root;
    protected Configuration config;
    protected CreateResourceReport createReport;
    protected ConfigurationUpdateReport updateReport;
    protected File deploymentFile;
    protected String securityConfig;
    private static final String MBEAN_NAME = "MBeanName";
    protected static final String ATTRIBUTE = "attribute";

    public void deleteComponent(File deploymentFile, String name) {
        this.deploymentFile = deploymentFile;
        if (deploymentFile.exists()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(deploymentFile);
                this.root = doc.getRootElement();
                if (this.root != null) {
                    if (!this.root.getName().equals(this.rootElementString)) {
                        throw new RuntimeException(this.rootElementString + " file format exception on [" + deploymentFile + "], expected [" + this.rootElementString + "] element but found [" + this.root.getName() + "]");
                    }
                    Element datasourceElement = this.findComponentElement(name);
                    this.root.removeContent((Content)datasourceElement);
                }
                this.updateFile(doc);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void bindSimplePropertiesToXML(String elementName, String attributeName, Element componentElement) {
        List children = componentElement.getChildren(elementName);
        for (Element element : children) {
            Attribute attribute = element.getAttribute(attributeName);
            String propertyName = null;
            if (attribute != null) {
                propertyName = attribute.getValue();
            }
            String elementValue = element.getValue();
            if (propertyName == null || elementValue == null) continue;
            PropertySimple dependProperty = new PropertySimple(propertyName, (Object)elementValue);
            this.config.put((Property)dependProperty);
        }
    }

    protected void bindSimplePropertiesToConfiguration(String[] properties, String elementName, String attributeName, Element componentElement) {
        for (String simpleAttribute : properties) {
            String value;
            block5: {
                PropertySimple property = this.config.getSimple(simpleAttribute);
                if (property == null || (value = property.getStringValue()) == null) continue;
                if (elementName.equals(DEPENDS)) {
                    try {
                        ObjectName.getInstance(value);
                    }
                    catch (MalformedObjectNameException e) {
                        LOG.error((Object)("Dependency to " + value + " does not exist or is not deployed. Because of this invalid dependency, this Topic/Queue will not be deployed."));
                        property.setErrorMessage("'" + value + "' is not a valid JMX object name.");
                        if (this.updateReport != null) {
                            this.updateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                        }
                        if (this.createReport == null) break block5;
                        this.createReport.setStatus(CreateResourceStatus.FAILURE);
                    }
                }
            }
            Element element = new Element(elementName);
            Attribute attribute = new Attribute(attributeName, simpleAttribute);
            element.setAttribute(attribute);
            element.setText(value);
            componentElement.addContent((Content)element);
        }
    }

    protected Element findComponentElement(String name) {
        for (Object child : this.root.getChildren()) {
            String nameWithinMBean;
            Element childElement = (Element)child;
            String tagValue = childElement.getName();
            if (!tagValue.equals("mbean")) continue;
            String mBeanName = childElement.getAttribute("name").getValue();
            Element jndiElement = childElement.getChild(JNDI_NAME);
            if (!(jndiElement != null ? name.equals(jndiElement.getValue()) : (nameWithinMBean = this.type + ",name=" + name).equals(mBeanName))) continue;
            return childElement;
        }
        return null;
    }

    protected Element findSecurityConf(Element componentElement) {
        List attributeElements = componentElement.getChildren(ATTRIBUTE);
        if (attributeElements != null) {
            for (Element attributeElement : attributeElements) {
                Attribute attributeName = attributeElement.getAttribute("name");
                if (!attributeName.getValue().equals(this.securityConfig)) continue;
                return attributeElement;
            }
        }
        return null;
    }

    private void checkDependencies(String value, Property property) {
        block3: {
            try {
                ObjectName name = ObjectName.getInstance(value);
            }
            catch (MalformedObjectNameException e) {
                LOG.error((Object)("Dependency to " + value + " does not exist or is not deployed. because of this dependency this Topic/Queue will not deploy either."));
                property.setErrorMessage(value + " is not a valid value.");
                if (this.updateReport != null) {
                    this.updateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                }
                if (this.createReport == null) break block3;
                this.createReport.setStatus(CreateResourceStatus.FAILURE);
            }
        }
    }

    protected void loadNameProperty(Element mbeanElement) {
        String name = this.getNameFromMBeanElement(mbeanElement);
        PropertySimple dependProperty = new PropertySimple(MBEAN_NAME, (Object)name);
        this.config.put((Property)dependProperty);
    }

    protected String getNameProperty() {
        String name = "";
        PropertySimple property = this.config.getSimple(MBEAN_NAME);
        if (property != null) {
            name = property.getStringValue();
        }
        return name;
    }

    protected void updateIfNameChanged(Element mbeanElement) {
        String nameInConfiguration;
        String nameInXML = this.getNameFromMBeanElement(mbeanElement);
        if (!nameInXML.equals(nameInConfiguration = this.getNameProperty())) {
            this.addNameAttributeToMBeanElement(mbeanElement, nameInConfiguration);
        }
    }

    protected void addNameAttributeToMBeanElement(Element mbeanElement, String name) {
        Attribute nameAttribute = new Attribute("name", "");
        nameAttribute.setValue(this.type + ",name=" + name);
        mbeanElement.removeAttribute("name");
        mbeanElement.setAttribute(nameAttribute);
    }

    private String getNameFromMBeanElement(Element mbeanElement) {
        Attribute name = mbeanElement.getAttribute("name");
        String attributeValue = name.getValue();
        String[] piecesOfAttribute = attributeValue.split(",name=");
        String valueInAttribute = piecesOfAttribute[1];
        return valueInAttribute;
    }

    protected void updateFile(Document doc) throws JDOMException, IOException {
        if (!this.isSetToFailure()) {
            FileOutputStream fos = new FileOutputStream(this.deploymentFile);
            XMLOutputter outp = new XMLOutputter(Format.getPrettyFormat());
            outp.output(doc, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
    }

    private boolean isSetToFailure() {
        boolean isFailure = false;
        if (this.updateReport != null) {
            isFailure = this.updateReport.getStatus().equals((Object)ConfigurationUpdateStatus.FAILURE);
        }
        if (this.createReport != null) {
            isFailure = this.createReport.getStatus().equals((Object)CreateResourceStatus.FAILURE);
        }
        return isFailure;
    }

    public String getRootElementString() {
        return this.rootElementString;
    }

    public void setRootElementString(String rootElement) {
        this.rootElementString = rootElement;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Configuration loadConfiguration(File file, String name) {
        if (file == null) {
            return null;
        }
        this.deploymentFile = file;
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(this.deploymentFile);
            this.root = doc.getRootElement();
            if (!this.root.getName().equals(this.rootElementString)) {
                return null;
            }
            Element componentElement = this.findComponentElement(name);
            if (componentElement == null) {
                return null;
            }
            this.config = new Configuration();
            this.bindSimplePropertiesToXML(DEPENDS, "optional-attribute-name", componentElement);
            this.bindSimplePropertiesToXML(ATTRIBUTE, "name", componentElement);
            this.loadNameProperty(componentElement);
            Element securityConf = this.findSecurityConf(componentElement);
            if (securityConf != null) {
                Element security = securityConf.getChild("security");
                List roles = security.getChildren();
                PropertyList rolesList = new PropertyList(this.securityConfig);
                for (Element role : roles) {
                    PropertyMap map = new PropertyMap("role");
                    List attributes = role.getAttributes();
                    for (Attribute attribute : attributes) {
                        PropertySimple property = new PropertySimple(attribute.getName(), (Object)attribute.getValue());
                        map.put((Property)property);
                    }
                    rolesList.add((Property)map);
                }
                this.config.put((Property)rolesList);
            }
            return this.config;
        }
        catch (IOException e) {
            LOG.error((Object)("IOException when trying to read xml file for type " + this.type + " component " + name), (Throwable)e);
        }
        catch (JDOMException e) {
            LOG.error((Object)"Unable to convert resource into xml file elements", (Throwable)e);
        }
        return null;
    }
}

