/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.table.renderer;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.DataModel;
import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.resource.InternetResource;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.gui.table.component.RowSelectorComponent;
import org.rhq.core.gui.table.renderer.AbstractRenderer;
import org.rhq.core.gui.util.FacesComponentUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowSelectorRenderer
extends AbstractRenderer {
    private static final String TABLE_SCRIPT = "/org/rhq/core/gui/table/renderer/js/table.js";
    private InternetResource[] scripts;

    public void decode(FacesContext context, UIComponent component) {
        this.validateParameters(context, component);
        RowSelectorComponent rowSelector = (RowSelectorComponent)component;
        UIData data = this.getEnclosingData((UIComponent)rowSelector);
        List selectedDataObjects = this.getSelectedRowDataObjects(context, data);
        rowSelector.setSubmittedValue(selectedDataObjects);
        Set<String> selectedRowKeys = this.getSelectedRowKeys(context, data, rowSelector);
        String rowKeyString = this.getRowKeyAsString(context, component, data);
        if (selectedRowKeys.contains(rowKeyString)) {
            Object rowData = data.getRowData();
            selectedDataObjects.add(rowData);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.validateParameters(context, component);
        RowSelectorComponent rowSelector = (RowSelectorComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        RowSelectorComponent.Mode selectionMode = rowSelector.getMode();
        String type = selectionMode == RowSelectorComponent.Mode.single ? "radio" : "checkbox";
        writer.writeAttribute("type", (Object)type, "type");
        String clientId = component.getClientId(context);
        writer.writeAttribute("name", (Object)clientId, "clientId");
        UIData data = this.getEnclosingData((UIComponent)rowSelector);
        Object rowKey = this.getRowKey(data);
        writer.writeAttribute("value", rowKey, null);
        String onclick = "updateButtons('" + clientId + "')";
        String userSpecifiedOnclick = (String)rowSelector.getAttributes().get("onclick");
        if (userSpecifiedOnclick != null) {
            onclick = onclick + "; " + userSpecifiedOnclick;
        }
        writer.writeAttribute("onclick", (Object)onclick, "onclick");
        Boolean disabled = (Boolean)rowSelector.getAttributes().get("disabled");
        if (disabled != null && disabled.booleanValue()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.endElement("input");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.validateParameters(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("input");
    }

    @NotNull
    private List getSelectedRowDataObjects(FacesContext context, UIData data) {
        Map requestMap = context.getExternalContext().getRequestMap();
        this.initializeComponentId(context, (UIComponent)data);
        String selectedRowDataObjectsRequestAttributeName = data.getId() + ":" + "selectedRowDataObjects";
        ArrayList selectedDataObjects = (ArrayList)requestMap.get(selectedRowDataObjectsRequestAttributeName);
        if (selectedDataObjects == null) {
            selectedDataObjects = new ArrayList();
            requestMap.put(selectedRowDataObjectsRequestAttributeName, selectedDataObjects);
        }
        return selectedDataObjects;
    }

    @NotNull
    private Set<String> getSelectedRowKeys(FacesContext context, UIData data, RowSelectorComponent rowSelector) {
        Map requestMap = context.getExternalContext().getRequestMap();
        this.initializeComponentId(context, (UIComponent)data);
        String selectedRowKeysRequestAttributeName = data.getId() + ":" + "selectedRowKeys";
        Set selectedRowKeys = (Set)requestMap.get(selectedRowKeysRequestAttributeName);
        if (selectedRowKeys == null) {
            String requestParamName;
            Map requestParamMap = context.getExternalContext().getRequestParameterValuesMap();
            String[] selectedRowKeyArray = (String[])requestParamMap.get(requestParamName = rowSelector.getClientId(context));
            if (selectedRowKeyArray != null) {
                selectedRowKeys = new HashSet(selectedRowKeyArray.length);
                Collections.addAll(selectedRowKeys, selectedRowKeyArray);
                selectedRowKeys = Collections.unmodifiableSet(selectedRowKeys);
            } else {
                selectedRowKeys = Collections.emptySet();
            }
        }
        return selectedRowKeys;
    }

    private Object getRowKey(UIData data) {
        Object rowKey;
        DataModel dataModel = (DataModel)data.getAttributes().get("dataModel");
        if (data instanceof UIDataAdaptor && dataModel instanceof ExtendedDataModel) {
            UIDataAdaptor dataAdaptor = (UIDataAdaptor)data;
            rowKey = dataAdaptor.getRowKey();
        } else {
            Object rowData = data.getRowData();
            rowKey = this.getPrimaryKey(rowData);
        }
        return rowKey;
    }

    private String getRowKeyAsString(FacesContext context, UIComponent component, UIData data) {
        String rowKeyString;
        Object rowKey = this.getRowKey(data);
        if (data instanceof UIDataAdaptor) {
            UIDataAdaptor dataAdaptor = (UIDataAdaptor)data;
            Converter rowKeyConverter = dataAdaptor.getRowKeyConverter();
            rowKeyString = rowKeyConverter.getAsString(context, component, rowKey);
        } else {
            rowKeyString = String.valueOf(rowKey);
        }
        return rowKeyString;
    }

    private Object getPrimaryKey(Object object) {
        Method method;
        try {
            method = object.getClass().getMethod("getId", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(object.getClass() + " does not define a public getId() method.");
        }
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to invoke getId() on " + object + ".", e);
        }
    }

    @NotNull
    private UIData getEnclosingData(UIComponent component) {
        UIData data = FacesComponentUtility.getAncestorOfType(component, UIData.class);
        if (data == null) {
            throw new IllegalStateException("Enclosing UIData component (i.e. h:dataTable or rich:*dataTable) not found for component " + component + ".");
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InternetResource[] getScripts() {
        RowSelectorRenderer rowSelectorRenderer = this;
        synchronized (rowSelectorRenderer) {
            if (this.scripts == null) {
                this.scripts = new InternetResource[]{this.getResource(TABLE_SCRIPT)};
            }
        }
        return this.scripts;
    }
}

