/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cobbler;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.augeas.Augeas;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ResourceConfigurationFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.plugins.augeas.AugeasConfigurationComponent;
import org.rhq.plugins.augeas.helper.AugeasNode;
import org.rhq.plugins.augeas.helper.AugeasRawConfigHelper;
import org.rhq.plugins.augeas.helper.AugeasTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CobblerComponent
extends AugeasConfigurationComponent
implements AugeasTranslator,
ResourceConfigurationFacet {
    private static final String MODULES_PATH = "/etc/cobbler/modules.conf";
    private static final String SETTINGS_PATH = "/etc/cobbler/settings";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private AugeasRawConfigHelper rawConfigHelper;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        super.start(resourceContext);
        this.rawConfigHelper = new AugeasRawConfigHelper(this.getAugeasRootPath(), "/usr/share/augeas/lenses", this.getResourceConfigurationRootPath(), (AugeasTranslator)this);
        this.rawConfigHelper.addLens("CobblerSettings.lns", SETTINGS_PATH);
        this.rawConfigHelper.addLens("CobblerModules.lns", MODULES_PATH);
        this.rawConfigHelper.addNode(SETTINGS_PATH, "server");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "next_server");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "http_port");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "default_kickstart");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "snippetsdir");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "manage_dhcp");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "manage_dns");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "manage_reverse_zones");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "manage_forward_zones");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "default_virt_bridge");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "default_virt_file_size");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "default_virt_ram");
        this.rawConfigHelper.addNode(SETTINGS_PATH, "default_virt_type");
        this.rawConfigHelper.addNode(MODULES_PATH, "authentication/module");
        this.rawConfigHelper.addNode(MODULES_PATH, "authorization/module");
        this.rawConfigHelper.addNode(MODULES_PATH, "dhcp/module");
        this.rawConfigHelper.addNode(MODULES_PATH, "dns/module");
    }

    protected Object toPropertyValue(PropertyDefinitionSimple propDefSimple, Augeas augeas, AugeasNode node) {
        if ("manage_dhcp".equals(node.getName()) || "manage_dns".equals(node.getName())) {
            return "1".equals(augeas.get(node.getPath()));
        }
        return super.toPropertyValue(propDefSimple, augeas, node);
    }

    protected String toNodeValue(Augeas augeas, AugeasNode node, PropertyDefinitionSimple propDefSimple, PropertySimple propSimple) {
        if ("manage_dhcp".equals(node.getName()) || "manage_dns".equals(node.getName())) {
            if (propSimple.getBooleanValue().booleanValue()) {
                return "1";
            }
            return "0";
        }
        return super.toNodeValue(augeas, node, propDefSimple, propSimple);
    }

    protected void setupAugeasModules(Augeas augeas) {
        augeas.set("/augeas/load/CobblerSettings/lens", "CobblerSettings.lns");
        augeas.set("/augeas/load/CobblerSettings/incl[1]", SETTINGS_PATH);
        augeas.set("/augeas/load/CobblerModules/lens", "CobblerModules.lns");
        augeas.set("/augeas/load/CobblerModules/incl[1]", MODULES_PATH);
    }

    public AvailabilityType getAvailability() {
        return super.getAvailability();
    }

    public Set<RawConfiguration> loadRawConfigurations() {
        try {
            HashSet<RawConfiguration> configs = new HashSet<RawConfiguration>();
            RawConfiguration modules = new RawConfiguration();
            modules.setPath(MODULES_PATH);
            String contents = FileUtils.readFileToString((File)new File(MODULES_PATH));
            String sha256 = new MessageDigestGenerator("SHA-256").calcDigestString(contents);
            modules.setContents(contents, sha256);
            configs.add(modules);
            RawConfiguration settings = new RawConfiguration();
            settings.setPath(SETTINGS_PATH);
            contents = FileUtils.readFileToString((File)new File(SETTINGS_PATH));
            sha256 = new MessageDigestGenerator("SHA-256").calcDigestString(contents);
            settings.setContents(contents, sha256);
            configs.add(settings);
            return configs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration loadStructuredConfiguration() {
        try {
            return this.loadResourceConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RawConfiguration mergeRawConfiguration(Configuration from, RawConfiguration to) {
        try {
            RawConfiguration config = new RawConfiguration();
            this.rawConfigHelper.mergeRawConfig(from, to, config);
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void mergeStructuredConfiguration(RawConfiguration from, Configuration to) {
        try {
            this.rawConfigHelper.mergeStructured(from, to);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void persistRawConfiguration(RawConfiguration rawConfiguration) {
        try {
            this.rawConfigHelper.save(rawConfiguration);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void persistStructuredConfiguration(Configuration configuration) {
        try {
            this.updateStructuredConfiguration(configuration);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void validateRawConfiguration(RawConfiguration rawConfiguration) {
    }

    public void validateStructuredConfiguration(Configuration configuration) {
    }

    public Property createProperty(String propName, String augeasPath, Augeas aug) {
        if ("settings/manage_dhcp".equals(propName) || "settings/manage_dns".equals(propName)) {
            return new PropertySimple(propName, (Object)"1".equals(aug.get(augeasPath)));
        }
        return new PropertySimple(propName, (Object)aug.get(augeasPath));
    }

    public String getPropertyValue(String propName, Configuration from) {
        if ("settings/manage_dhcp".equals(propName) || "settings/manage_dns".equals(propName)) {
            PropertySimple prop = (PropertySimple)from.get(propName);
            if (prop.getBooleanValue().booleanValue()) {
                return "1";
            }
            return "0";
        }
        return from.getSimpleValue(propName, "");
    }
}

