/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.augeas.helper;

import org.rhq.plugins.augeas.helper.AugeasVariable;

public class AugeasNode {
    public static final char SEPARATOR_CHAR = '/';
    public static final char VARIABLE_CHAR = '$';
    public static final String SEPARATOR = new String(new char[]{'/'});
    private String path;

    public static String patchNodeName(String name) {
        int nextSlash;
        StringBuilder bld = new StringBuilder();
        int start = 0;
        do {
            nextSlash = name.indexOf(SEPARATOR, start);
            int nextOpenBracket = name.indexOf(91, start);
            int nextCloseBracket = name.indexOf(93, start);
            if (nextSlash > nextCloseBracket) {
                if (nextOpenBracket == -1) {
                    bld.append(name.substring(start, nextSlash + 1).replaceAll(" ", "\\\\ "));
                    continue;
                }
                bld.append(name.substring(start, nextOpenBracket).replaceAll(" ", "\\\\ ")).append(name, nextOpenBracket, nextCloseBracket + 1);
                continue;
            }
            if (nextSlash == -1) {
                nextSlash = name.length();
            }
            if (nextOpenBracket != -1) {
                bld.append(name.substring(start, nextOpenBracket).replaceAll(" ", "\\\\ ")).append(name, nextOpenBracket, nextCloseBracket + 1);
                nextSlash = nextCloseBracket;
                continue;
            }
            bld.append(name.substring(start).replaceAll(" ", "\\\\ "));
        } while ((start = nextSlash + 1) > 0 && start < name.length());
        return bld.toString();
    }

    public AugeasNode(String path) {
        if (path == null) {
            throw new IllegalArgumentException("'path' parameter must not be null.");
        }
        if (path.charAt(0) != '/' && path.charAt(0) != '$') {
            throw new IllegalArgumentException("Specified path (" + path + ") is not absolute.");
        }
        this.path = AugeasNode.patchNodeName(path);
    }

    public AugeasNode(AugeasNode parent, String name) {
        if (parent == null) {
            throw new IllegalArgumentException("'parentNode' parameter must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("'name' parameter must not be null.");
        }
        this.path = parent.getPath() + '/' + AugeasNode.patchNodeName(name);
    }

    public AugeasNode(String parentPath, String name) {
        this(new AugeasNode(parentPath), name);
    }

    public String getName() {
        int lastSlashIndex = this.path.lastIndexOf(47);
        return lastSlashIndex == 0 ? this.path : this.path.substring(lastSlashIndex + 1);
    }

    public String getPath() {
        return this.path;
    }

    public AugeasNode getParent() {
        String parentPath = this.getParentPath();
        if (parentPath.indexOf(47) == -1 && parentPath.startsWith("$")) {
            return new AugeasVariable(parentPath.substring("$".length()));
        }
        return new AugeasNode(parentPath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AugeasNode that = (AugeasNode)obj;
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }

    public String toString() {
        return this.path;
    }

    protected String getParentPath() {
        String path = this.getPath();
        if (path.equals(SEPARATOR)) {
            return path;
        }
        char lastChar = path.charAt(path.length() - 1);
        if (lastChar == '/') {
            path = path.substring(0, path.length() - 1);
        }
        int lastSlashIndex = path.lastIndexOf(47);
        return path.substring(0, lastSlashIndex);
    }
}

