/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.augeas.helper;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.augeas.Augeas;
import org.apache.commons.io.FileUtils;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.plugins.augeas.helper.AugeasTranslator;

public class AugeasRawConfigHelper {
    private String rootPath;
    private String loadPath;
    private String rootNodePath;
    private AugeasTranslator translator;
    private Map<String, List<String>> nodePaths = new HashMap<String, List<String>>();
    private final String transformPrefix = "/augeas/load/custom" + System.currentTimeMillis();
    private Map<String, String> configMap = new HashMap<String, String>();

    public AugeasRawConfigHelper(String augeasRootPath, String augeasLoadPath, String rootNode, AugeasTranslator t) {
        this.rootPath = augeasRootPath;
        this.loadPath = augeasLoadPath;
        this.rootNodePath = rootNode;
        this.translator = t;
    }

    public void addLens(String lensName, String configFilePath) {
        this.configMap.put(configFilePath, lensName);
    }

    public void addNode(String configFilePath, String nodeSuffix) {
        if (!this.nodePaths.containsKey(configFilePath)) {
            this.nodePaths.put(configFilePath, new LinkedList());
        }
        this.nodePaths.get(configFilePath).add(nodeSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeRawConfig(Configuration from, RawConfiguration existingConfig, RawConfiguration toUpdate) throws Exception {
        Augeas aug = null;
        try {
            String lens = this.configMap.get(existingConfig.getPath());
            aug = this.createAugeas(lens, existingConfig.getContents());
            String file = this.getFile(aug);
            for (String pathSuffix : this.nodePaths.get(existingConfig.getPath())) {
                String propName = ("/files" + existingConfig.getPath() + "/" + pathSuffix).substring(this.rootNodePath.length());
                String propValue = this.translator.getPropertyValue(propName, from);
                aug.set("/files" + file + "/" + pathSuffix, propValue);
            }
            aug.save();
            toUpdate.setPath(existingConfig.getPath());
            String contents = FileUtils.readFileToString((File)new File(file));
            String sha256 = new MessageDigestGenerator("SHA-256").calcDigestString(contents);
            toUpdate.setContents(contents, sha256);
        }
        finally {
            if (aug != null) {
                aug.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeStructured(RawConfiguration from, Configuration toUpdate) throws Exception {
        Augeas aug = null;
        try {
            String lens = this.configMap.get(from.getPath());
            aug = this.createAugeas(lens, from.getContents());
            String file = this.getFile(aug);
            for (String pathSuffix : this.nodePaths.get(from.getPath())) {
                String propName = ("/files" + from.getPath() + "/" + pathSuffix).substring(this.rootNodePath.length());
                String augeasPath = "/files" + file + "/" + pathSuffix;
                Property property = this.translator.createProperty(propName, augeasPath, aug);
                toUpdate.put(property);
            }
        }
        finally {
            if (aug != null) {
                aug.close();
            }
        }
    }

    public void save(RawConfiguration config) throws Exception {
        File f = new File(config.getPath());
        FileUtils.writeStringToFile((File)f, (String)config.getContents());
    }

    private String getFile(Augeas aug) {
        return aug.get(this.transformPrefix + "/incl");
    }

    private Augeas createAugeas(String lens, String contents) throws Exception {
        Augeas aug = new Augeas(this.rootPath, this.loadPath, Augeas.NO_MODL_AUTOLOAD);
        File fl = File.createTempFile("_rhq", null);
        FileUtils.writeStringToFile((File)fl, (String)contents);
        aug.set(this.transformPrefix + "/lens", lens);
        aug.set(this.transformPrefix + "/incl", fl.getAbsolutePath());
        aug.load();
        return aug;
    }

    private String normalizeToUnix(byte[] contents) throws UnsupportedEncodingException {
        String s = new String(contents, "UTF8");
        return s.replaceAll("\r\n", "\n");
    }
}

