/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.server;

import java.io.NotSerializableException;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;
import org.rhq.enterprise.communications.util.CommandTraceUtil;

public class IncomingCommandTrace {
    private static final Logger LOG = CommI18NFactory.getLogger(IncomingCommandTrace.class);

    public static void start(Command command) {
        if (LOG.isTraceEnabled()) {
            try {
                String cmdStr = CommandTraceUtil.getCommandString(command);
                String config = CommandTraceUtil.getConfigString(command);
                LOG.trace("recv.initiate", new Object[]{cmdStr, config});
                try {
                    int size = CommandTraceUtil.getCommandSize(command);
                    if (size > -1) {
                        LOG.warn("trace.size-threshold-exceeded.command", new Object[]{cmdStr, size});
                    }
                }
                catch (NotSerializableException nse) {
                    LOG.error("trace.not-serializable.command", new Object[]{cmdStr, nse});
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void finish(Command command, Object response) {
        if (LOG.isTraceEnabled()) {
            try {
                String cmdStr = CommandTraceUtil.getCommandString(command);
                String config = CommandTraceUtil.getConfigString(command);
                String respStr = CommandTraceUtil.getCommandResponseString(response);
                LOG.trace("recv.complete", new Object[]{cmdStr, config, respStr});
                try {
                    int size = CommandTraceUtil.getCommandResponseSize(response);
                    if (size > -1) {
                        LOG.warn("trace.size-threshold-exceeded.command-response", new Object[]{respStr, size});
                    }
                }
                catch (NotSerializableException nse) {
                    LOG.error("trace.not-serializable.command-response", new Object[]{respStr, nse});
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

