/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.PojoCache;
import org.jboss.cache.aop.util.ObjectUtil;
import org.jboss.cache.config.Option;

public class InternalDelegate {
    static Log log = LogFactory.getLog((String)InternalDelegate.class.getName());
    public static final String CLASS_INTERNAL = "__jboss:internal:class__";
    public static final String SERIALIZED = "__SERIALIZED__";
    public static final Fqn JBOSS_INTERNAL = new Fqn("__JBossInternal__");
    public static final Fqn JBOSS_INTERNAL_MAP = new Fqn(JBOSS_INTERNAL, "__RefMap__");
    private boolean cacheOperationSkipLocking = true;
    private Option skipLockOption_;
    private Option gravitateOption_;
    private Option localModeOption_;
    protected PojoCache cache_;

    InternalDelegate(PojoCache cache) {
        this.cache_ = cache;
        this.skipLockOption_ = new Option();
        if (this.cacheOperationSkipLocking) {
            this.skipLockOption_.setSuppressLocking(true);
        } else {
            this.skipLockOption_.setSuppressLocking(false);
        }
        this.localModeOption_ = new Option();
        this.localModeOption_.setCacheModeLocal(true);
        this.gravitateOption_ = new Option();
        this.gravitateOption_.setForceDataGravitation(true);
    }

    Option getLockOption() {
        return this.skipLockOption_;
    }

    protected AOPInstance getAopInstance(Fqn fqn) throws CacheException {
        return (AOPInstance)this.get(fqn, AOPInstance.KEY, false);
    }

    protected AOPInstance getAopInstanceWithGravitation(Fqn fqn) throws CacheException {
        return (AOPInstance)this.get(fqn, AOPInstance.KEY, true);
    }

    AOPInstance initializeAopInstance(Fqn fqn) throws CacheException {
        AOPInstance aopInstance = new AOPInstance();
        aopInstance.incrementRefCount(null);
        return aopInstance;
    }

    int incrementRefCount(Fqn originalFqn, Fqn referencingFqn) throws CacheException {
        AOPInstance aopInstanceOrig = this.getAopInstance(originalFqn);
        if (aopInstanceOrig == null) {
            throw new RuntimeException("InternalDelegate.incrementRefCount(): null aopInstance for fqn: " + originalFqn);
        }
        AOPInstance aopInstance = aopInstanceOrig.copy();
        int count = aopInstance.incrementRefCount(referencingFqn);
        this.put(originalFqn, AOPInstance.KEY, aopInstance);
        return count;
    }

    protected Object get(Fqn fqn, Object key) throws CacheException {
        return this.get(fqn, key, false);
    }

    protected Object get(Fqn fqn, Object key, boolean gravitate) throws CacheException {
        if (gravitate && this.cache_.getBuddyManager() != null) {
            return this.cache_.get(fqn, key, this.gravitateOption_);
        }
        if (this.cache_.getCacheLoader() != null) {
            return this.cache_.get(fqn, key, this.skipLockOption_);
        }
        return this.cache_._get(fqn, key, false);
    }

    protected void put(Fqn fqn, Object key, Object value) throws CacheException {
        this.cache_.put(fqn, key, value, this.skipLockOption_);
    }

    protected void put(Fqn fqn, Map map) throws CacheException {
        this.cache_.put(fqn, map, this.skipLockOption_);
    }

    protected void localPut(Fqn fqn, Object key, Object value) throws CacheException {
        this.cache_.put(fqn, key, value, this.localModeOption_);
    }

    int decrementRefCount(Fqn originalFqn, Fqn referencingFqn) throws CacheException {
        AOPInstance aopInstanceOrig = this.getAopInstance(originalFqn);
        if (aopInstanceOrig == null) {
            throw new RuntimeException("InternalDelegate.decrementRefCount(): null aopInstance.");
        }
        AOPInstance aopInstance = aopInstanceOrig.copy();
        int count = aopInstance.decrementRefCount(referencingFqn);
        if (count < -1) {
            throw new RuntimeException("InternalDelegate.decrementRefCount(): null aopInstance.");
        }
        this.put(originalFqn, AOPInstance.KEY, aopInstance);
        return count;
    }

    boolean isReferenced(AOPInstance aopInstance, Fqn fqn) throws CacheException {
        return aopInstance.getRefCount() > 0;
    }

    int getRefCount(Fqn fqn) throws CacheException {
        return this.getAopInstance(fqn).getRefCount();
    }

    String getRefFqn(Fqn fqn) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(fqn);
        return this.getRefFqn(aopInstance, fqn);
    }

    String getRefFqn(AOPInstance aopInstance, Fqn fqn) throws CacheException {
        if (aopInstance == null) {
            return null;
        }
        String aliasFqn = aopInstance.getRefFqn();
        if (aliasFqn == null || aliasFqn.length() == 0) {
            return null;
        }
        return this.getRefFqnFromAlias(aliasFqn);
    }

    void setRefFqn(Fqn fqn, String internalFqn) throws CacheException {
        AOPInstance aopInstanceOrig = this.getAopInstance(fqn);
        AOPInstance aopInstance = null;
        aopInstance = aopInstanceOrig == null ? new AOPInstance() : aopInstanceOrig.copy();
        aopInstance.setRefFqn(internalFqn);
        this.put(fqn, AOPInstance.KEY, aopInstance);
    }

    void removeRefFqn(Fqn fqn) throws CacheException {
        AOPInstance aopInstanceOrig = this.getAopInstance(fqn);
        if (aopInstanceOrig == null) {
            throw new RuntimeException("InternalDelegate.getRefFqn(): null aopInstance.");
        }
        AOPInstance aopInstance = aopInstanceOrig.copy();
        aopInstance.removeRefFqn();
        this.put(fqn, AOPInstance.KEY, aopInstance);
    }

    Object getPojo(Fqn fqn) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(fqn);
        if (aopInstance == null) {
            return null;
        }
        return aopInstance.get();
    }

    Object getPojoWithGravitation(Fqn fqn) throws CacheException {
        AOPInstance aopInstance = this.getAopInstanceWithGravitation(fqn);
        if (aopInstance == null) {
            return null;
        }
        return aopInstance.get();
    }

    void setPojo(Fqn fqn, Object pojo) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(fqn);
        if (aopInstance == null) {
            aopInstance = new AOPInstance();
            this.put(fqn, AOPInstance.KEY, aopInstance);
        }
        aopInstance.set(pojo);
    }

    void setPojo(AOPInstance aopInstance, Object pojo) throws CacheException {
        aopInstance.set(pojo);
    }

    void setPojo(Fqn fqn, Object pojo, AOPInstance aopInstance) throws CacheException {
        if (aopInstance == null) {
            aopInstance = new AOPInstance();
            this.put(fqn, AOPInstance.KEY, aopInstance);
        }
        aopInstance.set(pojo);
    }

    void putAopClazz(Fqn fqn, Class clazz) throws CacheException {
        this.put(fqn, CLASS_INTERNAL, clazz);
    }

    void putAopClazz(Fqn fqn, Class clazz, Map map) throws CacheException {
        map.put(CLASS_INTERNAL, clazz);
    }

    Class peekAopClazz(Fqn fqn) throws CacheException {
        return (Class)this.get(fqn, CLASS_INTERNAL);
    }

    boolean isAopNode(Fqn fqn) throws CacheException {
        DataNode node = this.cache_.peek(fqn);
        if (node == null) {
            return false;
        }
        return node.get(AOPInstance.KEY) != null;
    }

    void removeInternalAttributes(Fqn fqn) throws CacheException {
        this.cache_.remove(fqn, AOPInstance.KEY);
        this.cache_.remove(fqn, (Object)CLASS_INTERNAL);
    }

    void cleanUp(Fqn fqn, boolean evict) throws CacheException {
        if (!evict) {
            Map children = this.cache_._get(fqn).getChildren();
            if (children == null || children.size() == 0) {
                this.cache_.remove(fqn);
            } else {
                this.cache_.removeData(fqn);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("cleanup(): fqn: " + fqn + " is not empty. That means it has sub-pojos. Will not remove node"));
                }
            }
        } else {
            this.cache_.plainEvict(fqn);
        }
    }

    String createIndirectFqn(String fqn) throws CacheException {
        String indirectFqn = this.getIndirectFqn(fqn);
        Fqn internalFqn = this.getInternalFqn(fqn);
        this.put(internalFqn, indirectFqn, fqn);
        return indirectFqn;
    }

    Fqn getInternalFqn(String fqn) {
        if (fqn == null || fqn.length() == 0) {
            throw new IllegalStateException("InternalDelegate.getInternalFqn(). fqn is either null or empty!");
        }
        String indirectFqn = this.getIndirectFqn(fqn);
        return new Fqn(JBOSS_INTERNAL_MAP, indirectFqn);
    }

    String getIndirectFqn(String fqn) {
        return ObjectUtil.getIndirectFqn(fqn);
    }

    void removeIndirectFqn(String oldFqn) throws CacheException {
        String indirectFqn = this.getIndirectFqn(oldFqn);
        this.cache_.remove(this.getInternalFqn(oldFqn), (Object)indirectFqn);
    }

    void setIndirectFqn(String oldFqn, String newFqn) throws CacheException {
        String indirectFqn = this.getIndirectFqn(oldFqn);
        Fqn tmpFqn = this.getInternalFqn(oldFqn);
        if (this.cache_.exists(tmpFqn, (Object)indirectFqn)) {
            this.put(tmpFqn, indirectFqn, newFqn);
        }
    }

    void updateIndirectFqn(Fqn originalFqn, Fqn newFqn) throws CacheException {
        this.put(this.getInternalFqn(originalFqn.toString()), this.getIndirectFqn(originalFqn.toString()), newFqn.toString());
    }

    String getRefFqnFromAlias(String aliasFqn) throws CacheException {
        return (String)this.get(this.getInternalFqn(aliasFqn), aliasFqn, true);
    }

    Fqn getNextFqnInLine(Fqn currentFqn) throws CacheException {
        AOPInstance ai = this.getAopInstance(currentFqn);
        return ai.getAndRemoveFirstFqnInList();
    }

    void relocate(Fqn thisFqn, Fqn newFqn) throws CacheException {
        Node node = this.cache_.get(thisFqn);
        Map value = node.getData();
        this.cache_.put(newFqn, value);
        Map children = node.getChildren();
        if (children == null || children.size() == 0) {
            this.cache_.remove(thisFqn);
            return;
        }
        Iterator it = children.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Fqn thisChildFqn = new Fqn(thisFqn, key);
            Fqn newChildFqn = new Fqn(newFqn, key);
            this.relocate(thisChildFqn, newChildFqn);
        }
        this.cache_.remove(thisFqn);
    }

    public static boolean isInternalNode(Fqn fqn) {
        return fqn.isChildOrEquals(JBOSS_INTERNAL);
    }
}

