/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.generator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.generator.RssGenerationException;
import churchillobjects.rss4j.generator.RssGeneratorImpl090;
import churchillobjects.rss4j.model.DateLanguageUtil;
import java.util.Enumeration;
import org.w3c.dom.Element;

class RssGeneratorImpl091
extends RssGeneratorImpl090 {
    private static final String DOCTYPE = "-//Netscape Communications//DTD RSS 0.91//EN";
    private static final String DTD = "http://my.netscape.com/publish/formats/rss-0.91.dtd";
    private static final String VERSION = "0.91";

    RssGeneratorImpl091() throws RssGenerationException {
    }

    protected void setMaxLengths() {
        super.setMaxLengths();
        this.channelTitleMax = 100;
        this.channelLinkMax = 500;
        this.channelPubDate = 100;
        this.channelBuildDate = 100;
        this.channelManagingEditorMax = 100;
        this.channelWebmasterMax = 100;
        this.channelCopyrightMax = 100;
        this.channelDocsMax = 500;
        this.imageTitleMax = 100;
        this.imageDescriptionMax = 100;
        this.itemDescriptionMax = 500;
        this.textInputTitleMax = 100;
        this.textInputDescriptionMax = 500;
        this.textInputNameMax = 20;
        this.textInputLinkMax = 500;
    }

    protected void createRssDocument(RssDocument data) {
        this.doc = this.domImpl.createDocument(null, "rss", null);
        this.rootElement = this.doc.getDocumentElement();
        this.rootElement.setAttribute("version", VERSION);
    }

    protected void handleChannel(RssChannel channel) throws RssGenerationException {
        Element channelElement = this.doc.createElement("channel");
        this.rootElement.appendChild(channelElement);
        this.handleChannelTitle(channel, channelElement);
        this.handleChannelDescription(channel, channelElement);
        this.handleChannelLink(channel, channelElement);
        this.handleChannelLanguage(channel, channelElement);
        this.handleChannelPicsRating(channel, channelElement);
        this.handleChannelPubDate(channel, channelElement);
        this.handleChannelBuildDate(channel, channelElement);
        this.handleChannelManagingEditor(channel, channelElement);
        this.handleChannelWebmaster(channel, channelElement);
        this.handleChannelCopyright(channel, channelElement);
        this.handleChannelDocs(channel, channelElement);
        this.handleSkipDays(channel, channelElement);
        this.handleSkipHours(channel, channelElement);
        this.handleTextInput(channel, channelElement);
        this.handleImage(channel, channelElement);
        this.handleItems(channel, channelElement);
    }

    protected void handleSkipDays(RssChannel channel, Element channelElement) {
        Enumeration days = channel.skipDays();
        if (days.hasMoreElements()) {
            Element skipDaysElement = this.doc.createElement("skipDays");
            while (days.hasMoreElements()) {
                this.add(skipDaysElement, "day", (String)days.nextElement());
            }
            channelElement.appendChild(skipDaysElement);
        }
    }

    protected void handleSkipHours(RssChannel channel, Element channelElement) {
        Enumeration hours = channel.skipHours();
        if (hours.hasMoreElements()) {
            Element skipHoursElement = this.doc.createElement("skipHours");
            while (hours.hasMoreElements()) {
                this.add(skipHoursElement, "hour", hours.nextElement().toString());
            }
            channelElement.appendChild(skipHoursElement);
        }
    }

    protected void handleImage(RssChannel channel, Element channelElement) throws RssGenerationException {
        RssChannelImage image = channel.getChannelImage();
        if (image != null) {
            Element imageElement = this.doc.createElement("image");
            this.handleImageTitle(image, imageElement);
            this.handleImageUrl(image, imageElement);
            this.handleImageLink(image, imageElement);
            this.handleImageDescription(image, imageElement);
            this.handleImageHeight(image, imageElement);
            this.handleImageWidth(image, imageElement);
            channelElement.appendChild(imageElement);
        }
    }

    protected void handleItems(RssChannel channel, Element channelElement) throws RssGenerationException {
        if (channel.getItemCount() > 15) {
            throw new RssGenerationException("Channel in 0.91 RSS can only have 15 items");
        }
        Enumeration enumeration = channel.items();
        while (enumeration.hasMoreElements()) {
            RssChannelItem item = (RssChannelItem)enumeration.nextElement();
            Element itemElement = this.doc.createElement("item");
            this.handleItemTitle(item, itemElement);
            this.handleItemLink(item, itemElement);
            this.handleItemDescription(item, itemElement);
            channelElement.appendChild(itemElement);
        }
    }

    protected void handleTextInput(RssChannel channel, Element channelElement) throws RssGenerationException {
        RssChannelTextInput textInput = channel.getChannelTextInput();
        if (textInput != null) {
            Element textInputElement = this.doc.createElement("textInput");
            this.handleTextInputTitle(textInput, textInputElement);
            this.handleTextInputDescription(textInput, textInputElement);
            this.handleTextInputName(textInput, textInputElement);
            this.handleTextInputLink(textInput, textInputElement);
            channelElement.appendChild(textInputElement);
        }
    }

    protected void handleChannelLanguage(RssChannel channel, Element channelElement) throws RssGenerationException {
        String language = channel.getChannelLanguage();
        if (!DateLanguageUtil.isValidLanguage(language)) {
            throw new RssGenerationException("Channel language unknown or null: " + language);
        }
        this.add(channelElement, "language", language);
    }

    protected void handleChannelPicsRating(RssChannel channel, Element channelElement) throws RssGenerationException {
        String picsRating = channel.getChannelPicsRating();
        this.validateValueOptional(picsRating, "Channel PICS rating", 20, 500);
        this.add(channelElement, "rating", picsRating);
    }

    protected void handleChannelPubDate(RssChannel channel, Element channelElement) throws RssGenerationException {
        String pubDate = channel.getChannelPubDate();
        pubDate = this.truncate(pubDate, 100);
        this.validateValueOptional(pubDate, "Channel pub date", 100);
        this.add(channelElement, "pubDate", pubDate);
    }

    protected void handleChannelBuildDate(RssChannel channel, Element channelElement) throws RssGenerationException {
        String lastBuildDate = channel.getChannelLastBuildDate();
        lastBuildDate = this.truncate(lastBuildDate, 100);
        this.validateValueOptional(lastBuildDate, "Channel last build date", 100);
        this.add(channelElement, "lastBuildDate", lastBuildDate);
    }

    protected void handleChannelManagingEditor(RssChannel channel, Element channelElement) throws RssGenerationException {
        String managingEditor = channel.getChannelManagingEditor();
        managingEditor = this.truncate(managingEditor, 100);
        this.validateValueOptional(managingEditor, "Channel managing editor", 100);
        this.add(channelElement, "managingEditor", managingEditor);
    }

    protected void handleChannelWebmaster(RssChannel channel, Element channelElement) throws RssGenerationException {
        String webmaster = channel.getChannelWebmaster();
        webmaster = this.truncate(webmaster, 100);
        this.validateValueOptional(webmaster, "Channel webmaster", 100);
        this.add(channelElement, "webMaster", webmaster);
    }

    protected void handleChannelCopyright(RssChannel channel, Element channelElement) throws RssGenerationException {
        String copyright = channel.getChannelCopyright();
        copyright = this.truncate(copyright, 100);
        this.validateValueOptional(copyright, "Channel copyright", 100);
        this.add(channelElement, "copyright", copyright);
    }

    protected void handleChannelDocs(RssChannel channel, Element channelElement) throws RssGenerationException {
        String docs = channel.getChannelDocs();
        this.validateUri(docs);
        this.validateValueOptional(docs, "Channel docs", 500);
        this.add(channelElement, "docs", docs);
    }

    protected void handleImageDescription(RssChannelImage image, Element imageElement) throws RssGenerationException {
        String description = image.getImageDescription();
        this.validateValueOptional(description, "Image description", this.imageDescriptionMax);
        this.add(imageElement, "description", description);
    }

    protected void handleImageHeight(RssChannelImage image, Element imageElement) throws RssGenerationException {
        int height = image.getImageHeight();
        if (height > 400) {
            throw new RssGenerationException("Image height optional, value must be positive integer <= 400: " + height);
        }
        if (height != 0) {
            this.add(imageElement, "height", "" + height);
        }
    }

    protected void handleImageWidth(RssChannelImage image, Element imageElement) throws RssGenerationException {
        int width = image.getImageWidth();
        if (width > 144) {
            throw new RssGenerationException("Image width optional, value must be positive integer <= 144: " + width);
        }
        if (width != 0) {
            this.add(imageElement, "width", "" + width);
        }
    }

    protected void handleItemDescription(RssChannelItem item, Element itemElement) throws RssGenerationException {
        String description = item.getItemDescription();
        this.validateValueOptional(description, "Image description", this.itemDescriptionMax);
        this.add(itemElement, "description", description);
    }
}

