/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.DefaultResponseHandler;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.HrefStatus;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.ResponseHandler;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.io.BufferingOutputStream;
import com.bradmcevoy.io.FileUtils;
import com.bradmcevoy.io.ReadingException;
import com.bradmcevoy.io.StreamToStream;
import com.bradmcevoy.io.WritingException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressingResponseHandler
implements ResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(CompressingResponseHandler.class);
    private ResponseHandler wrapped;
    private int maxMemorySize = 100000;

    public CompressingResponseHandler() {
    }

    public CompressingResponseHandler(ResponseHandler wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void respondContent(Resource resource, Response response, Request request, Map<String, String> params) throws NotAuthorizedException {
        String acceptableContentTypes;
        String contentType;
        GetableResource r;
        if (resource instanceof GetableResource && this.canCompress(r = (GetableResource)resource, contentType = r.getContentType(acceptableContentTypes = request.getAcceptHeader()), request.getAcceptEncodingHeader())) {
            response.setContentEncodingHeader(Response.ContentEncoding.GZIP);
            BufferingOutputStream tempOut = new BufferingOutputStream(this.maxMemorySize);
            try {
                GZIPOutputStream gzipOut = new GZIPOutputStream(tempOut);
                r.sendContent(gzipOut, null, params, contentType);
                ((OutputStream)gzipOut).flush();
                ((OutputStream)gzipOut).close();
                tempOut.flush();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                FileUtils.close(tempOut);
            }
            log.debug("respondContent-compressed: " + resource.getClass());
            DefaultResponseHandler.setRespondContentCommonHeaders(response, resource);
            Long contentLength = tempOut.getSize();
            response.setContentLengthHeader(contentLength);
            response.setContentTypeHeader(contentType);
            DefaultResponseHandler.setCacheControl(r, response, request.getAuthorization());
            try {
                StreamToStream.readTo(tempOut.getInputStream(), response.getOutputStream());
            }
            catch (ReadingException ex) {
                throw new RuntimeException(ex);
            }
            catch (WritingException ex) {
                log.warn("exception writing, client probably closed connection", (Throwable)ex);
            }
            return;
        }
        this.wrapped.respondContent(resource, response, request, params);
    }

    private boolean canCompress(GetableResource r, String contentType, String acceptableEncodings) {
        log.debug("canCompress: contentType: " + contentType + " acceptable-encodings: " + acceptableEncodings);
        if (contentType != null) {
            boolean contentIsCompressable;
            boolean bl = contentIsCompressable = (contentType = contentType.toLowerCase()).contains("text") || contentType.contains("css") || contentType.contains("js") || contentType.contains("javascript");
            if (contentIsCompressable) {
                boolean supportsGzip = acceptableEncodings != null && acceptableEncodings.toLowerCase().indexOf("gzip") > -1;
                log.debug("supports gzip: " + supportsGzip);
                return supportsGzip;
            }
        }
        return false;
    }

    public void setWrapped(ResponseHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResponseHandler getWrapped() {
        return this.wrapped;
    }

    @Override
    public void respondNoContent(Resource resource, Response response, Request request) {
        this.wrapped.respondNoContent(resource, response, request);
    }

    @Override
    public void respondPartialContent(GetableResource resource, Response response, Request request, Map<String, String> params, Range range) throws NotAuthorizedException {
        this.wrapped.respondPartialContent(resource, response, request, params, range);
    }

    @Override
    public void respondCreated(Resource resource, Response response, Request request) {
        this.wrapped.respondCreated(resource, response, request);
    }

    @Override
    public void respondUnauthorised(Resource resource, Response response, Request request) {
        this.wrapped.respondUnauthorised(resource, response, request);
    }

    @Override
    public void respondMethodNotImplemented(Resource resource, Response response, Request request) {
        this.wrapped.respondMethodNotImplemented(resource, response, request);
    }

    @Override
    public void respondMethodNotAllowed(Resource res, Response response, Request request) {
        this.wrapped.respondMethodNotAllowed(res, response, request);
    }

    @Override
    public void respondConflict(Resource resource, Response response, Request request, String message) {
        this.wrapped.respondConflict(resource, response, request, message);
    }

    @Override
    public void respondRedirect(Response response, Request request, String redirectUrl) {
        this.wrapped.respondRedirect(response, request, redirectUrl);
    }

    @Override
    public void responseMultiStatus(Resource resource, Response response, Request request, List<HrefStatus> statii) {
        this.wrapped.responseMultiStatus(resource, response, request, statii);
    }

    @Override
    public void respondNotModified(GetableResource resource, Response response, Request request) {
        this.wrapped.respondNotModified(resource, response, request);
    }

    @Override
    public void respondNotFound(Response response, Request request) {
        this.wrapped.respondNotFound(response, request);
    }

    @Override
    public void respondWithOptions(Resource resource, Response response, Request request, List<Request.Method> methodsAllowed) {
        this.wrapped.respondWithOptions(resource, response, request, methodsAllowed);
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public int getMaxMemorySize() {
        return this.maxMemorySize;
    }
}

